---
layout: default
---

# Contributing guide

First of all, thanks for considering contributing to the course! 👍

## How you can contribute

There are several ways you can contribute to this course.

### Share the love ❤️

Think this course is useful? Let others discover it, by telling them in person, via Twitter or a blog post.

### Ask a question ⁉️

Trying out the material and got stuck? Post your question as an [issue on GitHub](https://github.com/plovercode/course-python-data/issues). While we cannot offer user support, we'll try to do our best to address it, as questions often lead to the discovery of bugs.

Want to ask a question in private? Contact the course maintainer by [email](jorisvandenbossche@gmail.com).

### Propose an idea 💡

Have an idea to improve the course? Take a look at the [issue list](https://github.com/plovercode/course-python-data/issues) to see if it isn't included or suggested yet. If not, suggest your idea as an [issue on GitHub](https://github.com/plovercode/course-python-data/issues/new).

### Report a bug 🐛

Using the course and discovered a bug or a typo? That's annoying! Don't let others have the same experience and report it as an [issue on GitHub](https://github.com/plovercode/course-python-data/issues/new) so we can fix it. A good bug report makes it easier for us to do so, so please include:

* Your operating system name and version (e.g. Mac OS 10.13.6).
* Any details about your local setup that might be helpful in troubleshooting.
* Detailed steps to reproduce the bug.

### Contribute code 📝

Care to fix issues or typo's? Awesome! 👏

Some notes to take into account:

- The course material is developed in the [course-python-data](https://github.com/plovercode/course-python-data) repository. When updating course material, edit the notebooks in the [course-python-data](https://github.com/plovercode/course-python-data) repository, the other ones (the ones used in the tutorial) are generated automatically.
- the exercises are cleared using the `nbtutor` notebook extension: <https://github.com/jorisvandenbossche/nbtutor>



