# Data manipulation, analysis and visualisation in Python

## Introduction

This course is intended for researchers that have at least basic programming skills in Python. It targets researchers that want to enhance their general data manipulation and analysis skills in Python. 

The course does not aim to provide a course in statistics or machine learning. It aims to provide researchers the means to effectively tackle commonly encountered data handling tasks in order to increase the overall efficiency of the research. 

The course has been developed as a specialist course for the Doctoral schools of Ghent University, but can be taught to others upon request (and the material is freely available to re-use).


## Getting started

The course uses Python 3 and some data analysis packages such as Pandas, Numpy and Matplotlib. To install the required libraries, we highly recommend using conda (https://conda-forge.org/download/), which allows you to install the required scientific libraries (this recommendation applies to all platforms, so for both Windows, Linux and Mac).

For detailed instructions to get started on your local machine , see the [setup instructions](./docs/setup.md).

In case you do not want to install everything and just want to try out the course material, use the environment setup by Binder [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/plovercode/DS-python-data-analysis/main?urlpath=lab/) and open de notebooks rightaway.


## Contributing

Found any typo or have a suggestion, see [how to contribute](./docs/contributing.md).


## Meta 
Authors: Joris Van den Bossche, Stijn Van Hoey

<img src="img/logo_flanders+richtingmorgen.png" width="79%"> 
<img src="img/doctoralschoolsprofiel_hq_rgb_web.png" width="20%"> 
