package org.teachingextensions.logo;

import java.awt.Color;
import java.util.Random;

/**
 * Every color under the
 * <font color="red">r</font><font color="yellow">a</font><font color="orange">i</font><font color="green">n</font><font color="blue">b</font><font color="purple">o</font><font
 * color="blue">w</font>,
 * and different ways to get them.
 */
public class Colors
{
  public static class Blues
  {
    /**
     * The color <font color="#000080"> Navy </font>
     * <table bgcolor="#000080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Navy            = Color.decode("#000080");
    /**
     * The color <font color="#00008B"> DarkBlue </font>
     * <table bgcolor="#00008B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkBlue        = Color.decode("#00008B");
    /**
     * The color <font color="#191970"> MidnightBlue </font>
     * <table bgcolor="#191970" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MidnightBlue    = Color.decode("#191970");
    /**
     * The color <font color="#0000CD"> MediumBlue </font>
     * <table bgcolor="#0000CD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumBlue      = Color.decode("#0000CD");
    /**
     * The color <font color="#0000FF"> Blue </font>
     * <table bgcolor="#0000FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Blue            = Color.decode("#0000FF");
    /**
     * The color <font color="#008080"> Teal </font>
     * <table bgcolor="#008080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Teal            = Color.decode("#008080");
    /**
     * The color <font color="#483D8B"> DarkSlateBlue </font>
     * <table bgcolor="#483D8B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkSlateBlue   = Color.decode("#483D8B");
    /**
     * The color <font color="#008B8B"> DarkCyan </font>
     * <table bgcolor="#008B8B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkCyan        = Color.decode("#008B8B");
    /**
     * The color <font color="#4682B4"> SteelBlue </font>
     * <table bgcolor="#4682B4" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SteelBlue       = Color.decode("#4682B4");
    /**
     * The color <font color="#4169E1"> RoyalBlue </font>
     * <table bgcolor="#4169E1" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color RoyalBlue       = Color.decode("#4169E1");
    /**
     * The color <font color="#6A5ACD"> SlateBlue </font>
     * <table bgcolor="#6A5ACD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SlateBlue       = Color.decode("#6A5ACD");
    /**
     * The color <font color="#5F9EA0"> CadetBlue </font>
     * <table bgcolor="#5F9EA0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color CadetBlue       = Color.decode("#5F9EA0");
    /**
     * The color <font color="#00CED1"> DarkTurquoise </font>
     * <table bgcolor="#00CED1" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkTurquoise   = Color.decode("#00CED1");
    /**
     * The color <font color="#1E90FF"> DodgerBlue </font>
     * <table bgcolor="#1E90FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DodgerBlue      = Color.decode("#1E90FF");
    /**
     * The color <font color="#00BFFF"> DeepSkyBlue </font>
     * <table bgcolor="#00BFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DeepSkyBlue     = Color.decode("#00BFFF");
    /**
     * The color <font color="#7B68EE"> MediumSlateBlue </font>
     * <table bgcolor="#7B68EE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumSlateBlue = Color.decode("#7B68EE");
    /**
     * The color <font color="#48D1CC"> MediumTurquoise </font>
     * <table bgcolor="#48D1CC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumTurquoise = Color.decode("#48D1CC");
    /**
     * The color <font color="#6495ED"> CornflowerBlue </font>
     * <table bgcolor="#6495ED" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color CornflowerBlue  = Color.decode("#6495ED");
    /**
     * The color <font color="#40E0D0"> Turquoise </font>
     * <table bgcolor="#40E0D0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Turquoise       = Color.decode("#40E0D0");
    /**
     * The color <font color="#00FFFF"> Aqua </font>
     * <table bgcolor="#00FFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Aqua            = Color.decode("#00FFFF");
    /**
     * The color <font color="#00FFFF"> Cyan </font>
     * <table bgcolor="#00FFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Cyan            = Color.decode("#00FFFF");
    /**
     * The color <font color="#87CEEB"> SkyBlue </font>
     * <table bgcolor="#87CEEB" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SkyBlue         = Color.decode("#87CEEB");
    /**
     * The color <font color="#87CEFA"> LightSkyBlue </font>
     * <table bgcolor="#87CEFA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSkyBlue    = Color.decode("#87CEFA");
    /**
     * The color <font color="#7FFFD4"> Aquamarine </font>
     * <table bgcolor="#7FFFD4" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Aquamarine      = Color.decode("#7FFFD4");
    /**
     * The color <font color="#B0C4DE"> LightSteelBlue </font>
     * <table bgcolor="#B0C4DE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSteelBlue  = Color.decode("#B0C4DE");
    /**
     * The color <font color="#ADD8E6"> LightBlue </font>
     * <table bgcolor="#ADD8E6" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightBlue       = Color.decode("#ADD8E6");
    /**
     * The color <font color="#B0E0E6"> PowderBlue </font>
     * <table bgcolor="#B0E0E6" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PowderBlue      = Color.decode("#B0E0E6");
    /**
     * The color <font color="#AFEEEE"> PaleTurquoise </font>
     * <table bgcolor="#AFEEEE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleTurquoise   = Color.decode("#AFEEEE");
    /**
     * The color <font color="#E0FFFF"> LightCyan </font>
     * <table bgcolor="#E0FFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightCyan       = Color.decode("#E0FFFF");
    /**
     * The color <font color="#F0F8FF"> AliceBlue </font>
     * <table bgcolor="#F0F8FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color AliceBlue       = Color.decode("#F0F8FF");
    /**
     * The color <font color="#F0FFFF"> Azure </font>
     * <table bgcolor="#F0FFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Azure           = Color.decode("#F0FFFF");
  }
  public static class Browns
  {
    /**
     * The color <font color="#800000"> Maroon </font>
     * <table bgcolor="#800000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Maroon         = Color.decode("#800000");
    /**
     * The color <font color="#8B4513"> SaddleBrown </font>
     * <table bgcolor="#8B4513" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SaddleBrown    = Color.decode("#8B4513");
    /**
     * The color <font color="#A52A2A"> Brown </font>
     * <table bgcolor="#A52A2A" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Brown          = Color.decode("#A52A2A");
    /**
     * The color <font color="#A0522D"> Sienna </font>
     * <table bgcolor="#A0522D" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Sienna         = Color.decode("#A0522D");
    /**
     * The color <font color="#B8860B"> DarkGoldenrod </font>
     * <table bgcolor="#B8860B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkGoldenrod  = Color.decode("#B8860B");
    /**
     * The color <font color="#D2691E"> Chocolate </font>
     * <table bgcolor="#D2691E" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Chocolate      = Color.decode("#D2691E");
    /**
     * The color <font color="#CD853F"> Peru </font>
     * <table bgcolor="#CD853F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Peru           = Color.decode("#CD853F");
    /**
     * The color <font color="#DAA520"> Goldenrod </font>
     * <table bgcolor="#DAA520" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Goldenrod      = Color.decode("#DAA520");
    /**
     * The color <font color="#BC8F8F"> RosyBrown </font>
     * <table bgcolor="#BC8F8F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color RosyBrown      = Color.decode("#BC8F8F");
    /**
     * The color <font color="#F4A460"> SandyBrown </font>
     * <table bgcolor="#F4A460" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SandyBrown     = Color.decode("#F4A460");
    /**
     * The color <font color="#D2B48C"> Tan </font>
     * <table bgcolor="#D2B48C" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Tan            = Color.decode("#D2B48C");
    /**
     * The color <font color="#DEB887"> BurlyWood </font>
     * <table bgcolor="#DEB887" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color BurlyWood      = Color.decode("#DEB887");
    /**
     * The color <font color="#F5DEB3"> Wheat </font>
     * <table bgcolor="#F5DEB3" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Wheat          = Color.decode("#F5DEB3");
    /**
     * The color <font color="#FFDEAD"> NavajoWhite </font>
     * <table bgcolor="#FFDEAD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color NavajoWhite    = Color.decode("#FFDEAD");
    /**
     * The color <font color="#FFE4C4"> Bisque </font>
     * <table bgcolor="#FFE4C4" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Bisque         = Color.decode("#FFE4C4");
    /**
     * The color <font color="#FFEBCD"> BlanchedAlmond </font>
     * <table bgcolor="#FFEBCD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color BlanchedAlmond = Color.decode("#FFEBCD");
    /**
     * The color <font color="#FFF8DC"> Cornsilk </font>
     * <table bgcolor="#FFF8DC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Cornsilk       = Color.decode("#FFF8DC");
  }
  public static class Grays
  {
    /**
     * The color <font color="#000000"> Black </font>
     * <table bgcolor="#000000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Black          = Color.decode("#000000");
    /**
     * The color <font color="#2F4F4F"> DarkSlateGray </font>
     * <table bgcolor="#2F4F4F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkSlateGray  = Color.decode("#2F4F4F");
    /**
     * The color <font color="#696969"> DimGray </font>
     * <table bgcolor="#696969" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DimGray        = Color.decode("#696969");
    /**
     * The color <font color="#808080"> Gray </font>
     * <table bgcolor="#808080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Gray           = Color.decode("#808080");
    /**
     * The color <font color="#708090"> SlateGray </font>
     * <table bgcolor="#708090" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SlateGray      = Color.decode("#708090");
    /**
     * The color <font color="#778899"> LightSlateGray </font>
     * <table bgcolor="#778899" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSlateGray = Color.decode("#778899");
    /**
     * The color <font color="#A9A9A9"> DarkGray </font>
     * <table bgcolor="#A9A9A9" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkGray       = Color.decode("#A9A9A9");
    /**
     * The color <font color="#C0C0C0"> Silver </font>
     * <table bgcolor="#C0C0C0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Silver         = Color.decode("#C0C0C0");
    /**
     * The color <font color="#D3D3D3"> LightGray </font>
     * <table bgcolor="#D3D3D3" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightGray      = Color.decode("#D3D3D3");
    /**
     * The color <font color="#DCDCDC"> Gainsboro </font>
     * <table bgcolor="#DCDCDC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Gainsboro      = Color.decode("#DCDCDC");
  }
  public static class Greens
  {
    /**
     * The color <font color="#006400"> DarkGreen </font>
     * <table bgcolor="#006400" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkGreen         = Color.decode("#006400");
    /**
     * The color <font color="#008000"> Green </font>
     * <table bgcolor="#008000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Green             = Color.decode("#008000");
    /**
     * The color <font color="#228B22"> ForestGreen </font>
     * <table bgcolor="#228B22" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color ForestGreen       = Color.decode("#228B22");
    /**
     * The color <font color="#556B2F"> DarkOliveGreen </font>
     * <table bgcolor="#556B2F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkOliveGreen    = Color.decode("#556B2F");
    /**
     * The color <font color="#00FF00"> Lime </font>
     * <table bgcolor="#00FF00" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Lime              = Color.decode("#00FF00");
    /**
     * The color <font color="#808000"> Olive </font>
     * <table bgcolor="#808000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Olive             = Color.decode("#808000");
    /**
     * The color <font color="#008080"> Teal </font>
     * <table bgcolor="#008080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Teal              = Color.decode("#008080");
    /**
     * The color <font color="#2E8B57"> SeaGreen </font>
     * <table bgcolor="#2E8B57" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SeaGreen          = Color.decode("#2E8B57");
    /**
     * The color <font color="#008B8B"> DarkCyan </font>
     * <table bgcolor="#008B8B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkCyan          = Color.decode("#008B8B");
    /**
     * The color <font color="#6B8E23"> OliveDrab </font>
     * <table bgcolor="#6B8E23" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color OliveDrab         = Color.decode("#6B8E23");
    /**
     * The color <font color="#32CD32"> LimeGreen </font>
     * <table bgcolor="#32CD32" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LimeGreen         = Color.decode("#32CD32");
    /**
     * The color <font color="#3CB371"> MediumSeaGreen </font>
     * <table bgcolor="#3CB371" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumSeaGreen    = Color.decode("#3CB371");
    /**
     * The color <font color="#7CFC00"> LawnGreen </font>
     * <table bgcolor="#7CFC00" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LawnGreen         = Color.decode("#7CFC00");
    /**
     * The color <font color="#20B2AA"> LightSeaGreen </font>
     * <table bgcolor="#20B2AA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSeaGreen     = Color.decode("#20B2AA");
    /**
     * The color <font color="#7FFF00"> Chartreuse </font>
     * <table bgcolor="#7FFF00" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Chartreuse        = Color.decode("#7FFF00");
    /**
     * The color <font color="#00FF7F"> SpringGreen </font>
     * <table bgcolor="#00FF7F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SpringGreen       = Color.decode("#00FF7F");
    /**
     * The color <font color="#00FA9A"> MediumSpringGreen </font>
     * <table bgcolor="#00FA9A" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumSpringGreen = Color.decode("#00FA9A");
    /**
     * The color <font color="#9ACD32"> YellowGreen </font>
     * <table bgcolor="#9ACD32" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color YellowGreen       = Color.decode("#9ACD32");
    /**
     * The color <font color="#00CED1"> DarkTurquoise </font>
     * <table bgcolor="#00CED1" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkTurquoise     = Color.decode("#00CED1");
    /**
     * The color <font color="#8FBC8F"> DarkSeaGreen </font>
     * <table bgcolor="#8FBC8F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkSeaGreen      = Color.decode("#8FBC8F");
    /**
     * The color <font color="#ADFF2F"> GreenYellow </font>
     * <table bgcolor="#ADFF2F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color GreenYellow       = Color.decode("#ADFF2F");
    /**
     * The color <font color="#66CDAA"> MediumAquamarine </font>
     * <table bgcolor="#66CDAA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumAquamarine  = Color.decode("#66CDAA");
    /**
     * The color <font color="#48D1CC"> MediumTurquoise </font>
     * <table bgcolor="#48D1CC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumTurquoise   = Color.decode("#48D1CC");
    /**
     * The color <font color="#40E0D0"> Turquoise </font>
     * <table bgcolor="#40E0D0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Turquoise         = Color.decode("#40E0D0");
    /**
     * The color <font color="#90EE90"> LightGreen </font>
     * <table bgcolor="#90EE90" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightGreen        = Color.decode("#90EE90");
    /**
     * The color <font color="#98FB98"> PaleGreen </font>
     * <table bgcolor="#98FB98" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleGreen         = Color.decode("#98FB98");
    /**
     * The color <font color="#7FFFD4"> Aquamarine </font>
     * <table bgcolor="#7FFFD4" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Aquamarine        = Color.decode("#7FFFD4");
    /**
     * The color <font color="#AFEEEE"> PaleTurquoise </font>
     * <table bgcolor="#AFEEEE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleTurquoise     = Color.decode("#AFEEEE");
  }
  public static class Oranges
  {
    /**
     * The color <font color="#FF4500"> OrangeRed </font>
     * <table bgcolor="#FF4500" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color OrangeRed   = Color.decode("#FF4500");
    /**
     * The color <font color="#FF8C00"> DarkOrange </font>
     * <table bgcolor="#FF8C00" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkOrange  = Color.decode("#FF8C00");
    /**
     * The color <font color="#FFA500"> Orange </font>
     * <table bgcolor="#FFA500" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Orange      = Color.decode("#FFA500");
    /**
     * The color <font color="#FF6347"> Tomato </font>
     * <table bgcolor="#FF6347" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Tomato      = Color.decode("#FF6347");
    /**
     * The color <font color="#FF7F50"> Coral </font>
     * <table bgcolor="#FF7F50" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Coral       = Color.decode("#FF7F50");
    /**
     * The color <font color="#FFA07A"> LightSalmon </font>
     * <table bgcolor="#FFA07A" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSalmon = Color.decode("#FFA07A");
  }
  public static class Pinks
  {
    /**
     * The color <font color="#C71585"> MediumVioletRed </font>
     * <table bgcolor="#C71585" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <font color="#FF1493"> DeepPink </font>
     * <table bgcolor="#FF1493" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DeepPink        = Color.decode("#FF1493");
    /**
     * The color <font color="#DB7093"> PaleVioletRed </font>
     * <table bgcolor="#DB7093" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <font color="#FF00FF"> Fuchsia </font>
     * <table bgcolor="#FF00FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Fuchsia         = Color.decode("#FF00FF");
    /**
     * The color <font color="#FF69B4"> HotPink </font>
     * <table bgcolor="#FF69B4" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color HotPink         = Color.decode("#FF69B4");
    /**
     * The color <font color="#FFB6C1"> LightPink </font>
     * <table bgcolor="#FFB6C1" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightPink       = Color.decode("#FFB6C1");
    /**
     * The color <font color="#FFC0CB"> Pink </font>
     * <table bgcolor="#FFC0CB" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Pink            = Color.decode("#FFC0CB");
  }
  public static class Purples
  {
    /**
     * The color <font color="#4B0082"> Indigo </font>
     * <table bgcolor="#4B0082" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Indigo          = Color.decode("#4B0082");
    /**
     * The color <font color="#800080"> Purple </font>
     * <table bgcolor="#800080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Purple          = Color.decode("#800080");
    /**
     * The color <font color="#483D8B"> DarkSlateBlue </font>
     * <table bgcolor="#483D8B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkSlateBlue   = Color.decode("#483D8B");
    /**
     * The color <font color="#8B008B"> DarkMagenta </font>
     * <table bgcolor="#8B008B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkMagenta     = Color.decode("#8B008B");
    /**
     * The color <font color="#C71585"> MediumVioletRed </font>
     * <table bgcolor="#C71585" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <font color="#9400D3"> DarkViolet </font>
     * <table bgcolor="#9400D3" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkViolet      = Color.decode("#9400D3");
    /**
     * The color <font color="#6A5ACD"> SlateBlue </font>
     * <table bgcolor="#6A5ACD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color SlateBlue       = Color.decode("#6A5ACD");
    /**
     * The color <font color="#8A2BE2"> BlueViolet </font>
     * <table bgcolor="#8A2BE2" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color BlueViolet      = Color.decode("#8A2BE2");
    /**
     * The color <font color="#9932CC"> DarkOrchid </font>
     * <table bgcolor="#9932CC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkOrchid      = Color.decode("#9932CC");
    /**
     * The color <font color="#7B68EE"> MediumSlateBlue </font>
     * <table bgcolor="#7B68EE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumSlateBlue = Color.decode("#7B68EE");
    /**
     * The color <font color="#BC8F8F"> RosyBrown </font>
     * <table bgcolor="#BC8F8F" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color RosyBrown       = Color.decode("#BC8F8F");
    /**
     * The color <font color="#9370DB"> MediumPurple </font>
     * <table bgcolor="#9370DB" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumPurple    = Color.decode("#9370DB");
    /**
     * The color <font color="#DB7093"> PaleVioletRed </font>
     * <table bgcolor="#DB7093" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <font color="#BA55D3"> MediumOrchid </font>
     * <table bgcolor="#BA55D3" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumOrchid    = Color.decode("#BA55D3");
    /**
     * The color <font color="#FF00FF"> Fuchsia </font>
     * <table bgcolor="#FF00FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Fuchsia         = Color.decode("#FF00FF");
    /**
     * The color <font color="#FF00FF"> Magenta </font>
     * <table bgcolor="#FF00FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Magenta         = Color.decode("#FF00FF");
    /**
     * The color <font color="#DA70D6"> Orchid </font>
     * <table bgcolor="#DA70D6" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Orchid          = Color.decode("#DA70D6");
    /**
     * The color <font color="#DDA0DD"> Plum </font>
     * <table bgcolor="#DDA0DD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Plum            = Color.decode("#DDA0DD");
    /**
     * The color <font color="#EE82EE"> Violet </font>
     * <table bgcolor="#EE82EE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Violet          = Color.decode("#EE82EE");
    /**
     * The color <font color="#D8BFD8"> Thistle </font>
     * <table bgcolor="#D8BFD8" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Thistle         = Color.decode("#D8BFD8");
    /**
     * The color <font color="#E6E6FA"> Lavender </font>
     * <table bgcolor="#E6E6FA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Lavender        = Color.decode("#E6E6FA");
  }
  public static class Reds
  {
    /**
     * The color <font color="#8B0000"> DarkRed </font>
     * <table bgcolor="#8B0000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkRed         = Color.decode("#8B0000");
    /**
     * The color <font color="#B22222"> FireBrick </font>
     * <table bgcolor="#B22222" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color FireBrick       = Color.decode("#B22222");
    /**
     * The color <font color="#FF0000"> Red </font>
     * <table bgcolor="#FF0000" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Red             = Color.decode("#FF0000");
    /**
     * The color <font color="#DC143C"> Crimson </font>
     * <table bgcolor="#DC143C" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Crimson         = Color.decode("#DC143C");
    /**
     * The color <font color="#FF4500"> OrangeRed </font>
     * <table bgcolor="#FF4500" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color OrangeRed       = Color.decode("#FF4500");
    /**
     * The color <font color="#C71585"> MediumVioletRed </font>
     * <table bgcolor="#C71585" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <font color="#CD5C5C"> IndianRed </font>
     * <table bgcolor="#CD5C5C" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color IndianRed       = Color.decode("#CD5C5C");
    /**
     * The color <font color="#FF6347"> Tomato </font>
     * <table bgcolor="#FF6347" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Tomato          = Color.decode("#FF6347");
    /**
     * The color <font color="#DB7093"> PaleVioletRed </font>
     * <table bgcolor="#DB7093" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <font color="#FA8072"> Salmon </font>
     * <table bgcolor="#FA8072" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Salmon          = Color.decode("#FA8072");
    /**
     * The color <font color="#F08080"> LightCoral </font>
     * <table bgcolor="#F08080" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightCoral      = Color.decode("#F08080");
    /**
     * The color <font color="#E9967A"> DarkSalmon </font>
     * <table bgcolor="#E9967A" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkSalmon      = Color.decode("#E9967A");
    /**
     * The color <font color="#FFA07A"> LightSalmon </font>
     * <table bgcolor="#FFA07A" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightSalmon     = Color.decode("#FFA07A");
  }
  public static class Whites
  {
    /**
     * The color <font color="#FAEBD7"> AntiqueWhite </font>
     * <table bgcolor="#FAEBD7" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color AntiqueWhite  = Color.decode("#FAEBD7");
    /**
     * The color <font color="#FFE4E1"> MistyRose </font>
     * <table bgcolor="#FFE4E1" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MistyRose     = Color.decode("#FFE4E1");
    /**
     * The color <font color="#F5F5DC"> Beige </font>
     * <table bgcolor="#F5F5DC" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Beige         = Color.decode("#F5F5DC");
    /**
     * The color <font color="#FAF0E6"> Linen </font>
     * <table bgcolor="#FAF0E6" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Linen         = Color.decode("#FAF0E6");
    /**
     * The color <font color="#FDF5E6"> OldLace </font>
     * <table bgcolor="#FDF5E6" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color OldLace       = Color.decode("#FDF5E6");
    /**
     * The color <font color="#F0FFF0"> Honeydew </font>
     * <table bgcolor="#F0FFF0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Honeydew      = Color.decode("#F0FFF0");
    /**
     * The color <font color="#F5F5F5"> WhiteSmoke </font>
     * <table bgcolor="#F5F5F5" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color WhiteSmoke    = Color.decode("#F5F5F5");
    /**
     * The color <font color="#FFF5EE"> Seashell </font>
     * <table bgcolor="#FFF5EE" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Seashell      = Color.decode("#FFF5EE");
    /**
     * The color <font color="#FFF0F5"> LavenderBlush </font>
     * <table bgcolor="#FFF0F5" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LavenderBlush = Color.decode("#FFF0F5");
    /**
     * The color <font color="#F0F8FF"> AliceBlue </font>
     * <table bgcolor="#F0F8FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color AliceBlue     = Color.decode("#F0F8FF");
    /**
     * The color <font color="#FFFAF0"> FloralWhite </font>
     * <table bgcolor="#FFFAF0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color FloralWhite   = Color.decode("#FFFAF0");
    /**
     * The color <font color="#F5FFFA"> MintCream </font>
     * <table bgcolor="#F5FFFA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color MintCream     = Color.decode("#F5FFFA");
    /**
     * The color <font color="#F0FFFF"> Azure </font>
     * <table bgcolor="#F0FFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Azure         = Color.decode("#F0FFFF");
    /**
     * The color <font color="#FFFFF0"> Ivory </font>
     * <table bgcolor="#FFFFF0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Ivory         = Color.decode("#FFFFF0");
    /**
     * The color <font color="#F8F8FF"> GhostWhite </font>
     * <table bgcolor="#F8F8FF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color GhostWhite    = Color.decode("#F8F8FF");
    /**
     * The color <font color="#FFFAFA"> Snow </font>
     * <table bgcolor="#FFFAFA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Snow          = Color.decode("#FFFAFA");
    /**
     * The color <font color="#FFFFFF"> White </font>
     * <table bgcolor="#FFFFFF" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color White         = Color.decode("#FFFFFF");
  }
  public static class Yellows
  {
    /**
     * The color <font color="#B8860B"> DarkGoldenrod </font>
     * <table bgcolor="#B8860B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkGoldenrod        = Color.decode("#B8860B");
    /**
     * The color <font color="#DAA520"> Goldenrod </font>
     * <table bgcolor="#DAA520" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Goldenrod            = Color.decode("#DAA520");
    /**
     * The color <font color="#FFD700"> Gold </font>
     * <table bgcolor="#FFD700" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Gold                 = Color.decode("#FFD700");
    /**
     * The color <font color="#BDB76B"> DarkKhaki </font>
     * <table bgcolor="#BDB76B" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color DarkKhaki            = Color.decode("#BDB76B");
    /**
     * The color <font color="#FFFF00"> Yellow </font>
     * <table bgcolor="#FFFF00" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Yellow               = Color.decode("#FFFF00");
    /**
     * The color <font color="#F0E68C"> Khaki </font>
     * <table bgcolor="#F0E68C" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Khaki                = Color.decode("#F0E68C");
    /**
     * The color <font color="#EEE8AA"> PaleGoldenrod </font>
     * <table bgcolor="#EEE8AA" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PaleGoldenrod        = Color.decode("#EEE8AA");
    /**
     * The color <font color="#FFDAB9"> PeachPuff </font>
     * <table bgcolor="#FFDAB9" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PeachPuff            = Color.decode("#FFDAB9");
    /**
     * The color <font color="#FFE4B5"> Moccasin </font>
     * <table bgcolor="#FFE4B5" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color Moccasin             = Color.decode("#FFE4B5");
    /**
     * The color <font color="#FFEFD5"> PapayaWhip </font>
     * <table bgcolor="#FFEFD5" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color PapayaWhip           = Color.decode("#FFEFD5");
    /**
     * The color <font color="#FFFACD"> LemonChiffon </font>
     * <table bgcolor="#FFFACD" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LemonChiffon         = Color.decode("#FFFACD");
    /**
     * The color <font color="#FAFAD2"> LightGoldenrodYellow </font>
     * <table bgcolor="#FAFAD2" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightGoldenrodYellow = Color.decode("#FAFAD2");
    /**
     * The color <font color="#FFFFE0"> LightYellow </font>
     * <table bgcolor="#FFFFE0" width="25" height="25">
     * <tr>
     * <td>&nbsp;</td>
     * </tr>
     * </table>
     **/
    public static final Color LightYellow          = Color.decode("#FFFFE0");
  }
  private static Random RANDOM = new Random();
  public static Color darken(Color color)
  {
    int red = decrease(color.getRed(), 10);
    int green = decrease(color.getGreen(), 10);
    int blue = decrease(color.getBlue(), 10);
    return new Color(red, green, blue);
  }
  private static int decrease(int amount, int decreaseBy)
  {
    return Math.max(0, amount - decreaseBy);
  }
  public static Color getRandomColor()
  {
    return new Color(RANDOM.nextInt(255), RANDOM.nextInt(255), RANDOM.nextInt(255));
  }
  public static void mockRandom()
  {
    RANDOM.setSeed(5);
  }
  public static int calculateTransparency(int percentTransparent)
  {
    int opacity = (percentTransparent * 255) / 100;
    return (255 - opacity);
  }
  public static Color getTransparentVersion(Color color, int percentTransparency)
  {
    return new Color(color.getRed(), color.getGreen(), color.getBlue(), calculateTransparency(percentTransparency));
  }
}