/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.virtualproctor;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.teachingextensions.approvals.lite.util.MySystem;
import org.teachingextensions.approvals.lite.util.ThreadLauncher;
import org.teachingextensions.approvals.lite.util.ThreadUtils;
import org.teachingextensions.approvals.lite.util.io.FileUtils;
import org.teachingextensions.approvals.lite.util.lambda.Action0;
import org.teachingextensions.virtualproctor.ScreenCapture;
import org.teachingextensions.virtualproctor.VirtualProctor;

public class VirtualProctorWeb
extends WindowAdapter {
    private boolean finished = false;

    @Override
    public void windowClosing(WindowEvent event) {
        final BufferedImage scaled = ScreenCapture.getScaledImageOf(event.getComponent(), 200, 150);
        ThreadLauncher.launch(new Action0(){

            @Override
            public void call() {
                VirtualProctorWeb.this.sendImageToWeb(scaled);
                VirtualProctorWeb.this.finished = true;
            }
        });
    }

    public void sendImageToDisk(BufferedImage image) throws IOException {
        String filename = "C:\\temp\\VirtualProctor.png";
        ImageIO.write((RenderedImage)image, "png", new File(filename));
    }

    @Override
    public void windowClosed(WindowEvent e) {
        while (!this.finished) {
            ThreadUtils.sleep(50L);
        }
    }

    public void sendImageToWeb(BufferedImage image) {
        this.sendToWebLegacy(image);
        this.sendToWeb(image);
    }

    private void sendToWeb(BufferedImage image) {
        try {
            URL url = new URL("http://1.steady-fin-94022.appspot.com/screenshots");
            this.postImageToUrl(image, url);
        }
        catch (Exception e) {
            MySystem.event(e.getMessage());
        }
    }

    private void postImageToUrl(BufferedImage image, URL url) throws URISyntaxException, IOException, ClientProtocolException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost uploadFile = new HttpPost(url.toURI());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        builder.addBinaryBody("file", (InputStream)is, ContentType.APPLICATION_OCTET_STREAM, VirtualProctor.internals.getFullName());
        HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadFile);
        MySystem.event(response.getStatusLine().toString());
    }

    private void sendToWebLegacy(BufferedImage image) {
        try {
            String urlFormat = "http://virtualproctor-tkp.appspot.com/org.teachingkidsprogramming.virtualproctor.UploadImageRack?fileName=%s.png";
            String name = URLEncoder.encode(VirtualProctor.internals.getFullName(), "ISO-8859-1");
            URL url = new URL(String.format(urlFormat, name));
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            outputStream.close();
            String content = FileUtils.readStream((InputStream)connection.getContent());
            MySystem.event(content);
        }
        catch (UnknownHostException e) {
            MySystem.event("No internet connection");
        }
        catch (Exception e) {
            MySystem.warning(e);
        }
    }
}

