/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.virtualproctor;

import java.io.File;
import org.teachingextensions.approvals.lite.util.StringUtils;
import org.teachingextensions.approvals.lite.util.io.FileUtils;

public class VirtualProctor {
    public static void setName(String name) {
        internals.setName(name);
    }

    public static void setClassName(String className) {
        internals.setClassName(className);
    }

    public static class internals {
        private static final String FILE_NAME = ".virtual_proctor.txt";
        private static final String FILE_CLASS_NAME = ".class.virtual_proctor.txt";

        public static String getName() {
            String name = internals.getCustomName();
            if (name == null) {
                name = internals.getComputerName();
            }
            if (name == null) {
                name = internals.getUserName();
            }
            return name;
        }

        private static String getCustomName() {
            File file = new File(FILE_NAME);
            if (file.exists()) {
                return FileUtils.readFileWithSuppressedExceptions(file).trim();
            }
            return null;
        }

        public static String getComputerName() {
            return System.getenv("COMPUTERNAME");
        }

        public static String getUserName() {
            return System.getenv("USER");
        }

        public static void resetName() {
            File file = new File(FILE_NAME);
            if (file.exists()) {
                file.delete();
            }
        }

        public static void setName(String name) {
            if (StringUtils.isEmpty(name)) {
                return;
            }
            FileUtils.writeFileQuietly(new File(FILE_NAME), name);
        }

        public static void setClassName(String className) {
            if (StringUtils.isEmpty(className)) {
                return;
            }
            FileUtils.writeFileQuietly(new File(FILE_CLASS_NAME), className);
        }

        public static void resetClassName() {
            File file = new File(FILE_CLASS_NAME);
            if (file.exists()) {
                file.delete();
            }
        }

        public static String getClassName() {
            String name = internals.getCustomClassName();
            if (name == null) {
                name = "world";
            }
            return name;
        }

        private static String getCustomClassName() {
            File file = new File(FILE_CLASS_NAME);
            if (file.exists()) {
                return FileUtils.readFileWithSuppressedExceptions(file).trim();
            }
            return null;
        }

        public static String getFullName() {
            return internals.getClassName() + "." + internals.getName();
        }
    }
}

