/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.setup;

import java.io.File;
import org.teachingextensions.approvals.lite.util.SystemUtils;
import org.teachingextensions.approvals.lite.util.servlets.ValidationError;
import org.teachingextensions.setup.SetupValidator;

public class SetupConfig {
    public ValidationError setup = new ValidationError(SetupValidator.SetupCheckPoints.values());
    public String workspacePath = SystemUtils.isWindowsEnvironment() ? "." : System.getProperty("user.dir");
    private String eclipsePath;
    private static final String eclipsePathWindows = "c:\\eclipse\\eclipse.exe";
    private static final String eclipsePathMac = "/Applications/eclipse/Eclipse.app/Contents/MacOS/eclipse";

    public void assertSetupIsCorrect() {
        if (!this.setup.isOk()) {
            throw this.setup;
        }
    }

    public String getEclipsePath() {
        if (this.eclipsePath == null) {
            String brewEclipsePath;
            boolean exists;
            this.eclipsePath = SystemUtils.isWindowsEnvironment() ? eclipsePathWindows : ((exists = new File(brewEclipsePath = this.getBrewEclipsePath()).exists()) ? brewEclipsePath : eclipsePathMac);
        }
        return this.eclipsePath;
    }

    public String getBrewEclipsePath() {
        String brewEclipsePath = System.getProperty("user.home") + eclipsePathMac;
        brewEclipsePath = brewEclipsePath.replace("Applications/eclipse/", "Applications/");
        return brewEclipsePath;
    }
}

