/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.setup;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.approvals.lite.util.io.ZipUtils;

public class MacThumbDriveInstaller {
    public void install() throws Exception {
        this.installEclipse();
        this.installWorkspace();
        this.launch();
    }

    private void launch() {
        String command = "java -jar TKP_Launcher.jar";
        try {
            Runtime.getRuntime().exec(command, null, new File(this.getDesktop().getAbsolutePath() + "/TeachingKidsProgramming.Java-master"));
        }
        catch (IOException e) {
            ObjectUtils.throwAsError(e);
        }
    }

    private void installWorkspace() throws IOException {
        File zipFile = new File("./TeachingKidsProgramming.Java-master.zip");
        File unzipTo = this.getDesktop();
        System.out.println("Unzip to " + unzipTo);
        ZipUtils.doUnzip(unzipTo, zipFile);
    }

    public File getDesktop() {
        File homeDirectory = FileSystemView.getFileSystemView().getHomeDirectory();
        File unzipTo = new File(homeDirectory.getAbsolutePath() + "/Desktop");
        return unzipTo;
    }

    private void installEclipse() throws Exception {
        File installDir = new File("/Applications/Eclipse");
        if (installDir.exists()) {
            return;
        }
        ZipUtils.doUnzip(new File("/Applications"), new File("./eclipse-mac.zip"));
    }
}

