/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo.utils;

import org.teachingextensions.approvals.lite.Approvals;
import org.teachingextensions.approvals.lite.namer.ApprovalResults;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.logo.Turtle;

public class TortoiseUtils {
    private static Turtle TURTLE = new Turtle();

    public static void verify() {
        try {
            Approvals.verify(TURTLE.getImage());
        }
        catch (Exception e) {
            throw ObjectUtils.throwAsError(e);
        }
        finally {
            TortoiseUtils.resetTurtle();
        }
    }

    public static void resetTurtle() {
        TURTLE = new Turtle();
    }

    public static void setOrientation(int x, int y, int angle) {
        TURTLE.setX(x);
        TURTLE.setY(y);
        TURTLE.setAngleInDegrees(angle);
    }

    public static Turtle getTurtle() {
        return TURTLE;
    }

    public static void setTurtle(Turtle turtle) {
        TURTLE = turtle;
    }

    public static void verifyForOs() {
        ApprovalResults.UniqueForOs();
        TortoiseUtils.verify();
    }

    public static void writeMessage(String string, int x, int y) {
        TURTLE.setX(x);
        TURTLE.setY(y);
        TURTLE.print(string);
    }
}

