/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo.shapes;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.teachingextensions.logo.Paintable;
import org.teachingextensions.logo.PenColors;
import org.teachingextensions.windows.ProgramWindow;

public class Circle
implements Paintable {
    private final int radius;
    private final Color mainColor;
    private int x;
    private int y;
    private int percentTransparent;

    public Circle(int radius, Color color) {
        this.radius = radius;
        this.mainColor = color;
    }

    public void setCenter(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getRadius() {
        return this.radius;
    }

    public void addTo(ProgramWindow panel) {
        panel.addPaintable(this);
    }

    @Override
    public void paint(Graphics2D g, JPanel caller) {
        Color color2 = PenColors.getTransparentVersion(this.mainColor, this.percentTransparent);
        g.setColor(color2);
        g.fillOval(this.x - this.radius, this.y - this.radius, this.radius * 2, this.radius * 2);
    }

    public void setTransparency(int percentTransparent) {
        this.percentTransparent = percentTransparent;
    }

    public void removeFrom(ProgramWindow panel) {
        panel.removePaintable(this);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

