/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.util.ArrayList;
import java.util.List;
import org.teachingextensions.approvals.lite.util.NumberUtils;

public class Wheel<T> {
    private List<T> list = new ArrayList<T>();
    private int index = 0;

    @SafeVarargs
    public Wheel(T ... loadWith) {
        for (T t : loadWith) {
            this.add(t);
        }
    }

    public Wheel() {
    }

    public void add(T i) {
        this.list.add(i);
    }

    public T next() {
        this.assertNonEmpty();
        if (this.index >= this.list.size()) {
            this.index = 0;
        }
        return this.list.get(this.index++);
    }

    private void assertNonEmpty() {
        if (this.list.isEmpty()) {
            String message = "I call shenanigans!!!\nThis Wheel is empty\nYou can NOT get something from the Wheel before you've added anything to it.";
            throw new RuntimeException(message);
        }
    }

    public T getRandomFrom() {
        this.assertNonEmpty();
        int index = NumberUtils.getRandomInt(0, this.list.size());
        return this.list.get(index);
    }

    public void empty() {
        this.list.clear();
        this.index = 0;
    }
}

