/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.net.URL;
import javax.swing.ImageIcon;
import org.teachingextensions.logo.LineSegment;
import org.teachingextensions.logo.Turtle;
import org.teachingextensions.windows.ProgramWindow;

public class TurtlePanel
extends ProgramWindow {
    private static final long serialVersionUID = 3272676059303477850L;
    private Turtle turtle;
    private Image image;
    private Turtle.Animals animal;

    public TurtlePanel() {
    }

    public TurtlePanel(String string) {
        super(string);
    }

    public void setTurtle(Turtle turtle) {
        this.turtle = turtle;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintLines((Graphics2D)g);
        this.paintTurtle((Graphics2D)g);
    }

    private void paintLines(Graphics2D g) {
        if (this.turtle == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        for (LineSegment l : this.turtle.getTrail()) {
            if (l == null) continue;
            g.setColor(l.getColor());
            g.setStroke(new BasicStroke(l.getWidth(), 0, 0));
            g.draw(new Line2D.Double(l.getStart().x, l.getStart().y, l.getEnd().x, l.getEnd().y));
        }
    }

    private void paintTurtle(Graphics2D g) {
        if (this.turtle == null || this.turtle.isHidden()) {
            return;
        }
        Image image = this.getImage();
        int xCenter = image.getWidth(null) / 2;
        int yCenter = image.getHeight(null) / 2;
        int x = this.turtle.getX() - xCenter;
        int y = this.turtle.getY() - yCenter;
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(this.turtle.getHeadingInDegrees()), xCenter, yCenter);
        AffineTransform move = AffineTransform.getTranslateInstance(x, y);
        move.concatenate(rotate);
        g.drawImage(image, move, null);
    }

    public synchronized Image getImage() {
        if (this.image == null) {
            this.setAnimal(Turtle.Animals.Turtle);
        }
        return this.image;
    }

    public synchronized Turtle.Animals getAnimal() {
        if (this.animal == null) {
            this.setAnimal(Turtle.Animals.Turtle);
        }
        return this.animal;
    }

    public synchronized void setAnimal(Turtle.Animals animal) {
        this.animal = animal;
        String name = (Object)((Object)animal) + ".png";
        URL resource = this.getClass().getResource(name);
        if (resource == null) {
            resource = this.getClass().getClassLoader().getResource(name);
        }
        if (resource == null) {
            throw new IllegalStateException("Could not find animal: " + name);
        }
        this.image = new ImageIcon(resource).getImage();
    }

    public void setCursor(int cursor) {
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public void ___() {
    }
}

