/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.teachingextensions.approvals.lite.util.ThreadLauncher;
import org.teachingextensions.approvals.lite.util.lambda.Action0;
import org.teachingextensions.approvals.lite.util.persistence.Saver;
import org.teachingextensions.approvals.lite.util.persistence.SavingException;
import org.teachingextensions.approvals.lite.writers.ComponentApprovalWriter;
import org.teachingextensions.logo.LineSegment;
import org.teachingextensions.logo.TurtlePanel;
import org.teachingextensions.windows.ProgramWindow;

public class Turtle {
    public static final int TEST_SPEED = Integer.MIN_VALUE;
    private static final double MAX_MOVE_AMOUNT = 5.0;
    private double x = 320.0;
    private double y = 240.0;
    private double angleInDegrees = 0.0;
    private TurtlePanel panel;
    private int speed = 1;
    private List<LineSegment> trail = new ArrayList<LineSegment>();
    private Color color = Color.black;
    private int width = 2;
    private boolean penDown = true;
    private boolean hidden;
    private Animals animal;

    public static double getDeltaY(double i, double angleInDegrees2) {
        return -i * Math.cos(Math.toRadians(angleInDegrees2));
    }

    public static double getDeltaX(double i, double angleInDegrees2) {
        return i * Math.sin(Math.toRadians(angleInDegrees2));
    }

    public static double angleCalculator(int x1, int y1, int x2, int y2) {
        int delta_x = x1 - x2;
        int delta_y = y1 - y2;
        double theta_radians = Math.atan2(delta_y, delta_x);
        double degrees = Math.toDegrees(theta_radians);
        double degreesWith0North = degrees - 90.0;
        return degreesWith0North;
    }

    public BufferedImage getImage() {
        BufferedImage image = ComponentApprovalWriter.drawComponent(this.getPanel());
        this.clear();
        return image;
    }

    public void clear() {
        this.trail.clear();
        if (this.panel != null) {
            this.panel.removePaintable();
        }
    }

    private Component getPanel() {
        if (this.panel == null) {
            String title = "TKPJava Turtle";
            this.panel = new TurtlePanel();
            if (this.speed != Integer.MIN_VALUE) {
                JFrame frame = new JFrame(title);
                frame.getContentPane().add(this.panel);
                ProgramWindow.createStandardFrame(frame);
            }
            this.panel.setTurtle(this);
        }
        return this.panel;
    }

    public void setPanel(TurtlePanel panel) {
        this.panel = panel;
    }

    public int getX() {
        return (int)this.x;
    }

    public void setX(Number x) {
        this.x = x.doubleValue();
    }

    public int getY() {
        return (int)this.y;
    }

    public void setY(Number y) {
        this.y = y.doubleValue();
    }

    public double getAngleInDegrees() {
        return this.angleInDegrees;
    }

    public void setAngleInDegrees(double angleInDegrees) {
        this.angleInDegrees = angleInDegrees;
    }

    public void turn(double amount) {
        double max = this.getTurnAmount(amount);
        Turner s = new Turner();
        this.animate(amount, max, s);
    }

    private double getTurnAmount(double amount) {
        amount = Math.abs(amount);
        if (this.getSpeed() == Integer.MIN_VALUE) {
            return amount;
        }
        return amount / (double)(11 - this.getSpeed());
    }

    private void animate(double amount, double max, Saver<Double> s) {
        double sign = amount > 0.0 ? 1.0 : -1.0;
        for (amount = Math.abs(amount); amount > max; amount -= max) {
            s.save(max * sign);
            this.refreshPanel();
        }
        s.save(amount * sign);
        this.refreshPanel();
    }

    private void refreshPanel() {
        this.refreshPanel(this.getPanel());
    }

    private void refreshPanel(Component panel) {
        long delay = this.getDelay();
        if (delay != Integer.MIN_VALUE) {
            panel.repaint();
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void smallTurn(double i) {
        this.angleInDegrees += i;
    }

    private long getDelay() {
        if (this.getSpeed() == 10) {
            return 1L;
        }
        if (this.getSpeed() == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return 100 / this.getSpeed();
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        if (speed != Integer.MIN_VALUE && (speed < 1 || 10 < speed)) {
            throw new RuntimeException(String.format("I call shenanigans!!!\nThe speed '%s' is not between the acceptable range of [1-10]\nPerhaps you should read the documentation", speed));
        }
        this.speed = speed;
    }

    public double getHeadingInDegrees() {
        return this.angleInDegrees;
    }

    public void move(Number amount) {
        double max = 5.0;
        Saver<Double> s = this.penDown ? new Mover(new Point(this.getX(), this.getY())) : new EmptyMover();
        this.animate(amount.doubleValue(), max, s);
    }

    private void moveWithoutAnimation(Double save) {
        this.x += Turtle.getDeltaX(save, this.angleInDegrees);
        this.y += Turtle.getDeltaY(save, this.angleInDegrees);
    }

    public LineSegment[] getTrail() {
        return this.trail.toArray(new LineSegment[0]);
    }

    public Color getPenColor() {
        return this.color;
    }

    public void setPenColor(Color color) {
        this.color = color;
    }

    public int getPenWidth() {
        return this.width;
    }

    public void setPenWidth(int width) {
        this.width = width;
    }

    public void show() {
        this.hidden = false;
        this.refreshPanel();
    }

    public TurtlePanel getBackgroundWindow() {
        return (TurtlePanel)this.getPanel();
    }

    public void setAnimal(Animals animal) {
        this.refreshPanel();
        this.getBackgroundWindow().setAnimal(animal);
        this.animal = animal;
    }

    public void penUp() {
        this.penDown = false;
    }

    public void penDown() {
        this.penDown = true;
    }

    public void print(String string) {
    }

    public void hide() {
        this.hidden = true;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void moveTo(final int x, final int y) {
        ThreadLauncher.launch(new Action0(){

            @Override
            public void call() {
                Turtle.this.moveSynchronized(x, y);
            }
        });
    }

    public void moveSynchronized(int x, int y) {
        double angleOfWherePointIs = Turtle.angleCalculator(this.getX(), this.getY(), x, y);
        double direction = angleOfWherePointIs - this.getAngleInDegrees();
        this.turn(direction);
        double distance = new Point(x, y).distance(this.getX(), this.getY());
        this.move(distance);
    }

    public void drawStar(int size) {
        for (int i = 1; i <= 5; ++i) {
            this.turn(144.0);
            this.move(size);
        }
    }

    public boolean isDead() {
        return this.animal == Animals.ExplodedTurtle;
    }

    private class EmptyMover
    implements Saver<Double> {
        private EmptyMover() {
        }

        @Override
        public Double save(Double save) throws SavingException {
            Turtle.this.moveWithoutAnimation(save);
            return save;
        }
    }

    private class Mover
    implements Saver<Double> {
        private final Point starting;
        private LineSegment line = null;

        public Mover(Point point) {
            this.starting = point;
        }

        @Override
        public Double save(Double save) throws SavingException {
            Turtle.this.moveWithoutAnimation(save);
            if (this.line != null) {
                Turtle.this.trail.remove(this.line);
            }
            this.line = new LineSegment(Turtle.this.color, this.starting, new Point(Turtle.this.getX(), Turtle.this.getY()), Turtle.this.width);
            Turtle.this.trail.add(this.line);
            return save;
        }
    }

    private class Turner
    implements Saver<Double> {
        private Turner() {
        }

        @Override
        public Double save(Double save) throws SavingException {
            Turtle.this.smallTurn(save);
            return save;
        }
    }

    public static enum Animals {
        ExplodedTurtle,
        Turtle,
        Spider,
        Unicorn;

    }
}

