/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.logo.Puzzle;

public class Tile {
    private static final String[] resources = new String[]{"Batgirl1a.png", "Batgirl2a.png", "Batgirl3a.png", "Batgirl1b.png", "Batgirl2b.png", "Batgirl3b.png", "Batgirl1c.png", "Batgirl2c.png", "Batgirl3c.png"};
    private static final Point origin = new Point(35, 35);
    private final Image image;
    private final Dimension dimension = new Dimension(122, 122);
    private Point position;
    private Point target;

    public Tile(int cell, int image) {
        this.position = Tile.getPosition(cell);
        this.image = Tile.getImage(image);
    }

    public static Point getPosition(int cell) {
        Point offset = Puzzle.getPosition(cell);
        return new Point(Tile.origin.x + 127 * offset.x, Tile.origin.y + 127 * offset.y);
    }

    private static Image getImage(int image) {
        return ObjectUtils.loadImage(Tile.class, resources[image]);
    }

    private static int stepTowardGoal(int current, int goal) {
        if (current < goal) {
            return current + 1;
        }
        if (goal < current) {
            return current - 1;
        }
        return current;
    }

    public void paint(Graphics2D g2d) {
        g2d.drawImage(this.image, this.position.x, this.position.y, this.dimension.width, this.dimension.height, null);
    }

    public boolean isAtTarget() {
        return this.target == null || this.target.x == this.position.x && this.target.y == this.position.y;
    }

    public void step() {
        int x = Tile.stepTowardGoal(this.position.x, this.target.x);
        int y = Tile.stepTowardGoal(this.position.y, this.target.y);
        this.position = new Point(x, y);
    }

    public void moveTo(Point goal) {
        this.target = goal;
    }

    public String toString() {
        return "Tile{" + this.position.x + ", " + this.position.y + '}';
    }
}

