/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.teachingextensions.logo.Puzzle;

public class PuzzleState
implements Comparator<PuzzleState>,
Comparable<PuzzleState> {
    private final Puzzle puzzle;
    private final Stack<Direction> history;

    public PuzzleState(Puzzle puzzle) {
        this(puzzle, new Stack<Direction>());
    }

    public PuzzleState(Puzzle puzzle, Stack<Direction> history) {
        this.puzzle = puzzle;
        this.history = history;
    }

    public boolean isSolution() {
        return this.puzzle.isSolved();
    }

    public List<PuzzleState> getBranches() {
        ArrayList<PuzzleState> branches = new ArrayList<PuzzleState>(4);
        int blank = this.puzzle.getBlankIndex();
        int x = blank % 3;
        int y = blank / 3;
        for (Direction d : Direction.values()) {
            if (d == Direction.Left && x == 0 || d == Direction.Right && x == 2 || d == Direction.Up && y == 0 || d == Direction.Down && y == 2) continue;
            Stack<Direction> h = new Stack<Direction>();
            h.addAll(this.history);
            h.push(d);
            branches.add(new PuzzleState(this.puzzle.swapBlank(blank + d.getValue()), h));
        }
        return branches;
    }

    public Iterable<Direction> getHistory() {
        return this.history;
    }

    public Puzzle getPuzzle() {
        return this.puzzle;
    }

    public int getActualCost() {
        return this.history.size();
    }

    @Override
    public int compare(PuzzleState o1, PuzzleState o2) {
        return o1.getActualCost() - o2.getActualCost();
    }

    @Override
    public int compareTo(PuzzleState o) {
        return this.compare(this, o);
    }

    public int hashCode() {
        return this.puzzle.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PuzzleState that = (PuzzleState)o;
        return this.puzzle.equals(that.puzzle);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this.history.isEmpty()) {
            b.append((Object)this.history.peek());
            b.append(" to ");
        }
        b.append(this.puzzle);
        return b.toString();
    }

    public int getEstimatedCost() {
        return this.puzzle.getDistanceToGoal();
    }

    public static enum Direction {
        Left(-1),
        Right(1),
        Up(-3),
        Down(3);

        private final int value;

        private Direction(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "{" + super.toString() + " = " + this.value + '}';
        }
    }
}

