/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.teachingextensions.logo.Puzzle;
import org.teachingextensions.logo.PuzzleState;

public abstract class PuzzlePlayer {
    private final Puzzle puzzle;
    private final Set<PuzzleState> visited = new HashSet<PuzzleState>();
    private final Queue<PuzzleState> frontier;

    public PuzzlePlayer(Puzzle puzzle, Queue<PuzzleState> frontier) {
        this.puzzle = puzzle;
        this.frontier = frontier;
    }

    protected Set<PuzzleState> getVisited() {
        return this.visited;
    }

    protected Queue<PuzzleState> getFrontier() {
        return this.frontier;
    }

    protected Puzzle getPuzzle() {
        return this.puzzle;
    }

    public PuzzleState solve() {
        PuzzleState state = new PuzzleState(this.getPuzzle());
        do {
            this.getVisited().add(state);
            if (state.isSolution()) continue;
            this.search(state);
            if (this.getFrontier().isEmpty()) {
                throw new IllegalStateException("Cannot solve puzzle.");
            }
            state = this.getFrontier().remove();
        } while (!state.isSolution());
        return state;
    }

    protected void search(PuzzleState state) {
        List<PuzzleState> branches = state.getBranches();
        for (PuzzleState b : branches) {
            if (this.getVisited().contains(b)) continue;
            this.getFrontier().add(b);
        }
    }
}

