/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.swing.JPanel;
import org.teachingextensions.approvals.lite.util.StringUtils;
import org.teachingextensions.logo.PenColors;
import org.teachingextensions.logo.Puzzle;
import org.teachingextensions.logo.PuzzleState;
import org.teachingextensions.logo.Tile;
import org.teachingextensions.logo.TileMove;
import org.teachingextensions.windows.ProgramWindow;

public class PuzzleBoard
extends JPanel {
    private static final long serialVersionUID = -2008156268412728375L;
    private static final int blank = 8;
    private final Tile[] tiles;
    private final Queue<TileMove> solution;

    public PuzzleBoard(Puzzle puzzle, PuzzleState solution) {
        this.solution = PuzzleBoard.createSolution(solution, puzzle);
        this.tiles = PuzzleBoard.createTiles(puzzle.getCells());
    }

    public static Queue<TileMove> createSolution(PuzzleState solution, Puzzle puzzle) {
        if (solution == null) {
            return new ArrayDeque<TileMove>();
        }
        int i = puzzle.getBlankIndex();
        ArrayDeque<TileMove> moves = new ArrayDeque<TileMove>();
        for (PuzzleState.Direction d : solution.getHistory()) {
            int m = d.getValue();
            TileMove move = new TileMove(i + m, i);
            moves.add(move);
            i = move.getStart();
        }
        return moves;
    }

    private static Tile[] createTiles(int[] cells) {
        Tile[] t = new Tile[9];
        for (int i = 0; i < 9; ++i) {
            if (cells[i] == 8) continue;
            t[i] = new Tile(i, cells[i]);
        }
        return t;
    }

    private static void drawBorder(Graphics2D g) {
        g.setColor(PenColors.Blues.DarkBlue);
        g.fillRect(20, 20, 410, 410);
    }

    private static void drawField(Graphics2D g) {
        g.setColor(PenColors.Blues.SkyBlue);
        g.fillRect(30, 30, 386, 386);
    }

    private static void drawTiles(Graphics2D g, Tile[] tiles) {
        for (Tile tile : tiles) {
            if (tile == null) continue;
            tile.paint(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = ProgramWindow.configureGraphics2D(g);
        PuzzleBoard.drawBorder(g2d);
        PuzzleBoard.drawField(g2d);
        PuzzleBoard.drawTiles(g2d, this.tiles);
        g2d.dispose();
    }

    public Tile[] getTiles() {
        return Arrays.copyOf(this.tiles, this.tiles.length);
    }

    public boolean hasMoves() {
        return !this.solution.isEmpty();
    }

    public TileMove getNextMove() {
        return this.solution.isEmpty() ? null : this.solution.remove();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PuzzleBoard" + StringUtils.NEW_LINE);
        for (int i = 0; i < this.tiles.length; i += 3) {
            sb.append(this.tiles[i] + ", " + this.tiles[i + 1] + ", " + this.tiles[i + 2] + StringUtils.NEW_LINE);
        }
        return sb.toString();
    }

    public void swap(int start, int end) {
        Point p = Tile.getPosition(end);
        Tile tile = this.tiles[start];
        tile.moveTo(p);
        this.tiles[start] = null;
        this.tiles[end] = tile;
    }
}

