/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import javax.swing.SwingUtilities;
import org.teachingextensions.logo.PuzzleBoard;
import org.teachingextensions.logo.Tile;
import org.teachingextensions.logo.TileMove;

public class PuzzleAnimation
implements Runnable {
    private final PuzzleBoard board;

    public PuzzleAnimation(PuzzleBoard board) {
        this.board = board;
    }

    private static void update(PuzzleBoard board) {
        boolean done = PuzzleAnimation.animate(board);
        if (!done) {
            return;
        }
        PuzzleAnimation.moveNextTile(board);
    }

    private static void moveNextTile(PuzzleBoard board) {
        if (board.hasMoves()) {
            TileMove move = board.getNextMove();
            board.swap(move.getStart(), move.getEnd());
        }
    }

    private static boolean animate(PuzzleBoard board) {
        Tile[] tiles;
        for (Tile tile : tiles = board.getTiles()) {
            if (tile == null || tile.isAtTarget()) continue;
            tile.step();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        while (this.board.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PuzzleAnimation.this.board.repaint();
                }
            });
            PuzzleAnimation.update(this.board);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

