/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.Point;
import java.util.Arrays;

public class Puzzle {
    private static final int blank = 8;
    private final int[] cells;

    public Puzzle(int[] cells) {
        this.cells = cells;
    }

    public static Point getPosition(int cell) {
        return new Point(cell % 3, cell / 3);
    }

    public static int getDistance(Point start, Point end) {
        return Math.abs(start.x - end.x) + Math.abs(start.y - end.y);
    }

    public static int getDistance(int start, int end) {
        return Puzzle.getDistance(Puzzle.getPosition(start), Puzzle.getPosition(end));
    }

    public int hashCode() {
        return Arrays.hashCode(this.cells);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Puzzle puzzle = (Puzzle)o;
        return Arrays.equals(this.cells, puzzle.cells);
    }

    public String toString() {
        return Arrays.toString(this.cells);
    }

    public boolean isSolved() {
        return this.getDistanceToGoal() == 0;
    }

    public int getBlankIndex() {
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] != 8) continue;
            return i;
        }
        return -1;
    }

    public Puzzle swapBlank(int target) {
        int x;
        int[] copy = Arrays.copyOf(this.cells, this.cells.length);
        copy[this.getBlankIndex()] = x = copy[target];
        copy[target] = 8;
        return new Puzzle(copy);
    }

    public int getDistanceToGoal() {
        int distance = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            distance += Puzzle.getDistance(i, this.cells[i]);
        }
        return distance;
    }

    public int[] getCells() {
        return Arrays.copyOf(this.cells, this.cells.length);
    }
}

