/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.Color;
import java.util.Random;

public class PenColors {
    private static Random RANDOM = new Random();

    public static Color darken(Color color) {
        int red = PenColors.decrease(color.getRed(), 10);
        int green = PenColors.decrease(color.getGreen(), 10);
        int blue = PenColors.decrease(color.getBlue(), 10);
        return new Color(red, green, blue);
    }

    private static int decrease(int amount, int decreaseBy) {
        return Math.max(0, amount - decreaseBy);
    }

    public static Color lighten(Color color) {
        int red = PenColors.increase(color.getRed(), 10);
        int green = PenColors.increase(color.getGreen(), 10);
        int blue = PenColors.increase(color.getBlue(), 10);
        return new Color(red, green, blue);
    }

    private static int increase(int amount, int increaseBy) {
        return Math.min(255, amount + increaseBy);
    }

    public static Color getRandomColor() {
        return new Color(RANDOM.nextInt(255), RANDOM.nextInt(255), RANDOM.nextInt(255));
    }

    public static void mockRandom() {
        RANDOM.setSeed(5L);
    }

    public static int calculateTransparency(int percentTransparent) {
        int opacity = percentTransparent * 255 / 100;
        return 255 - opacity;
    }

    public static Color getTransparentVersion(Color color, int percentTransparency) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), PenColors.calculateTransparency(percentTransparency));
    }

    public static class Yellows {
        public static final Color DarkGoldenrod = Color.decode("#B8860B");
        public static final Color Goldenrod = Color.decode("#DAA520");
        public static final Color Gold = Color.decode("#FFD700");
        public static final Color DarkKhaki = Color.decode("#BDB76B");
        public static final Color Yellow = Color.decode("#FFFF00");
        public static final Color Khaki = Color.decode("#F0E68C");
        public static final Color PaleGoldenrod = Color.decode("#EEE8AA");
        public static final Color PeachPuff = Color.decode("#FFDAB9");
        public static final Color Moccasin = Color.decode("#FFE4B5");
        public static final Color PapayaWhip = Color.decode("#FFEFD5");
        public static final Color LemonChiffon = Color.decode("#FFFACD");
        public static final Color LightGoldenrodYellow = Color.decode("#FAFAD2");
        public static final Color LightYellow = Color.decode("#FFFFE0");
    }

    public static class Whites {
        public static final Color AntiqueWhite = Color.decode("#FAEBD7");
        public static final Color MistyRose = Color.decode("#FFE4E1");
        public static final Color Beige = Color.decode("#F5F5DC");
        public static final Color Linen = Color.decode("#FAF0E6");
        public static final Color OldLace = Color.decode("#FDF5E6");
        public static final Color Honeydew = Color.decode("#F0FFF0");
        public static final Color WhiteSmoke = Color.decode("#F5F5F5");
        public static final Color Seashell = Color.decode("#FFF5EE");
        public static final Color LavenderBlush = Color.decode("#FFF0F5");
        public static final Color AliceBlue = Color.decode("#F0F8FF");
        public static final Color FloralWhite = Color.decode("#FFFAF0");
        public static final Color MintCream = Color.decode("#F5FFFA");
        public static final Color Azure = Color.decode("#F0FFFF");
        public static final Color Ivory = Color.decode("#FFFFF0");
        public static final Color GhostWhite = Color.decode("#F8F8FF");
        public static final Color Snow = Color.decode("#FFFAFA");
        public static final Color White = Color.decode("#FFFFFF");
    }

    public static class Reds {
        public static final Color DarkRed = Color.decode("#8B0000");
        public static final Color FireBrick = Color.decode("#B22222");
        public static final Color Red = Color.decode("#FF0000");
        public static final Color Crimson = Color.decode("#DC143C");
        public static final Color OrangeRed = Color.decode("#FF4500");
        public static final Color MediumVioletRed = Color.decode("#C71585");
        public static final Color IndianRed = Color.decode("#CD5C5C");
        public static final Color Tomato = Color.decode("#FF6347");
        public static final Color PaleVioletRed = Color.decode("#DB7093");
        public static final Color Salmon = Color.decode("#FA8072");
        public static final Color LightCoral = Color.decode("#F08080");
        public static final Color DarkSalmon = Color.decode("#E9967A");
        public static final Color LightSalmon = Color.decode("#FFA07A");
    }

    public static class Purples {
        public static final Color Indigo = Color.decode("#4B0082");
        public static final Color Purple = Color.decode("#800080");
        public static final Color DarkSlateBlue = Color.decode("#483D8B");
        public static final Color DarkMagenta = Color.decode("#8B008B");
        public static final Color MediumVioletRed = Color.decode("#C71585");
        public static final Color DarkViolet = Color.decode("#9400D3");
        public static final Color SlateBlue = Color.decode("#6A5ACD");
        public static final Color BlueViolet = Color.decode("#8A2BE2");
        public static final Color DarkOrchid = Color.decode("#9932CC");
        public static final Color MediumSlateBlue = Color.decode("#7B68EE");
        public static final Color RosyBrown = Color.decode("#BC8F8F");
        public static final Color MediumPurple = Color.decode("#9370DB");
        public static final Color PaleVioletRed = Color.decode("#DB7093");
        public static final Color MediumOrchid = Color.decode("#BA55D3");
        public static final Color Fuchsia = Color.decode("#FF00FF");
        public static final Color Magenta = Color.decode("#FF00FF");
        public static final Color Orchid = Color.decode("#DA70D6");
        public static final Color Plum = Color.decode("#DDA0DD");
        public static final Color Violet = Color.decode("#EE82EE");
        public static final Color Thistle = Color.decode("#D8BFD8");
        public static final Color Lavender = Color.decode("#E6E6FA");
    }

    public static class Pinks {
        public static final Color MediumVioletRed = Color.decode("#C71585");
        public static final Color DeepPink = Color.decode("#FF1493");
        public static final Color PaleVioletRed = Color.decode("#DB7093");
        public static final Color Fuchsia = Color.decode("#FF00FF");
        public static final Color HotPink = Color.decode("#FF69B4");
        public static final Color LightPink = Color.decode("#FFB6C1");
        public static final Color Pink = Color.decode("#FFC0CB");
    }

    public static class Oranges {
        public static final Color OrangeRed = Color.decode("#FF4500");
        public static final Color DarkOrange = Color.decode("#FF8C00");
        public static final Color Orange = Color.decode("#FFA500");
        public static final Color Tomato = Color.decode("#FF6347");
        public static final Color Coral = Color.decode("#FF7F50");
        public static final Color LightSalmon = Color.decode("#FFA07A");
    }

    public static class Greens {
        public static final Color DarkGreen = Color.decode("#006400");
        public static final Color Green = Color.decode("#008000");
        public static final Color ForestGreen = Color.decode("#228B22");
        public static final Color DarkOliveGreen = Color.decode("#556B2F");
        public static final Color Lime = Color.decode("#00FF00");
        public static final Color Olive = Color.decode("#808000");
        public static final Color Teal = Color.decode("#008080");
        public static final Color SeaGreen = Color.decode("#2E8B57");
        public static final Color DarkCyan = Color.decode("#008B8B");
        public static final Color OliveDrab = Color.decode("#6B8E23");
        public static final Color LimeGreen = Color.decode("#32CD32");
        public static final Color MediumSeaGreen = Color.decode("#3CB371");
        public static final Color LawnGreen = Color.decode("#7CFC00");
        public static final Color LightSeaGreen = Color.decode("#20B2AA");
        public static final Color Chartreuse = Color.decode("#7FFF00");
        public static final Color SpringGreen = Color.decode("#00FF7F");
        public static final Color MediumSpringGreen = Color.decode("#00FA9A");
        public static final Color YellowGreen = Color.decode("#9ACD32");
        public static final Color DarkTurquoise = Color.decode("#00CED1");
        public static final Color DarkSeaGreen = Color.decode("#8FBC8F");
        public static final Color GreenYellow = Color.decode("#ADFF2F");
        public static final Color MediumAquamarine = Color.decode("#66CDAA");
        public static final Color MediumTurquoise = Color.decode("#48D1CC");
        public static final Color Turquoise = Color.decode("#40E0D0");
        public static final Color LightGreen = Color.decode("#90EE90");
        public static final Color PaleGreen = Color.decode("#98FB98");
        public static final Color Aquamarine = Color.decode("#7FFFD4");
        public static final Color PaleTurquoise = Color.decode("#AFEEEE");
    }

    public static class Grays {
        public static final Color Black = Color.decode("#000000");
        public static final Color DarkSlateGray = Color.decode("#2F4F4F");
        public static final Color DimGray = Color.decode("#696969");
        public static final Color Gray = Color.decode("#808080");
        public static final Color SlateGray = Color.decode("#708090");
        public static final Color LightSlateGray = Color.decode("#778899");
        public static final Color DarkGray = Color.decode("#A9A9A9");
        public static final Color Silver = Color.decode("#C0C0C0");
        public static final Color LightGray = Color.decode("#D3D3D3");
        public static final Color Gainsboro = Color.decode("#DCDCDC");
    }

    public static class Browns {
        public static final Color Maroon = Color.decode("#800000");
        public static final Color SaddleBrown = Color.decode("#8B4513");
        public static final Color Brown = Color.decode("#A52A2A");
        public static final Color Sienna = Color.decode("#A0522D");
        public static final Color DarkGoldenrod = Color.decode("#B8860B");
        public static final Color Chocolate = Color.decode("#D2691E");
        public static final Color Peru = Color.decode("#CD853F");
        public static final Color Goldenrod = Color.decode("#DAA520");
        public static final Color RosyBrown = Color.decode("#BC8F8F");
        public static final Color SandyBrown = Color.decode("#F4A460");
        public static final Color Tan = Color.decode("#D2B48C");
        public static final Color BurlyWood = Color.decode("#DEB887");
        public static final Color Wheat = Color.decode("#F5DEB3");
        public static final Color NavajoWhite = Color.decode("#FFDEAD");
        public static final Color Bisque = Color.decode("#FFE4C4");
        public static final Color BlanchedAlmond = Color.decode("#FFEBCD");
        public static final Color Cornsilk = Color.decode("#FFF8DC");
    }

    public static class Blues {
        public static final Color Navy = Color.decode("#000080");
        public static final Color DarkBlue = Color.decode("#00008B");
        public static final Color MidnightBlue = Color.decode("#191970");
        public static final Color MediumBlue = Color.decode("#0000CD");
        public static final Color Blue = Color.decode("#0000FF");
        public static final Color Teal = Color.decode("#008080");
        public static final Color DarkSlateBlue = Color.decode("#483D8B");
        public static final Color DarkCyan = Color.decode("#008B8B");
        public static final Color SteelBlue = Color.decode("#4682B4");
        public static final Color RoyalBlue = Color.decode("#4169E1");
        public static final Color SlateBlue = Color.decode("#6A5ACD");
        public static final Color CadetBlue = Color.decode("#5F9EA0");
        public static final Color DarkTurquoise = Color.decode("#00CED1");
        public static final Color DodgerBlue = Color.decode("#1E90FF");
        public static final Color DeepSkyBlue = Color.decode("#00BFFF");
        public static final Color MediumSlateBlue = Color.decode("#7B68EE");
        public static final Color MediumTurquoise = Color.decode("#48D1CC");
        public static final Color CornflowerBlue = Color.decode("#6495ED");
        public static final Color Turquoise = Color.decode("#40E0D0");
        public static final Color Aqua = Color.decode("#00FFFF");
        public static final Color Cyan = Color.decode("#00FFFF");
        public static final Color SkyBlue = Color.decode("#87CEEB");
        public static final Color LightSkyBlue = Color.decode("#87CEFA");
        public static final Color Aquamarine = Color.decode("#7FFFD4");
        public static final Color LightSteelBlue = Color.decode("#B0C4DE");
        public static final Color LightBlue = Color.decode("#ADD8E6");
        public static final Color PowderBlue = Color.decode("#B0E0E6");
        public static final Color PaleTurquoise = Color.decode("#AFEEEE");
        public static final Color LightCyan = Color.decode("#E0FFFF");
        public static final Color AliceBlue = Color.decode("#F0F8FF");
        public static final Color Azure = Color.decode("#F0FFFF");
    }
}

