/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.logo;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.logo.LineSegment;
import org.teachingextensions.logo.Turtle;
import org.teachingextensions.logo.TurtlePanel;
import org.teachingextensions.windows.ProgramWindow;

public class MultiTurtlePanel
extends TurtlePanel {
    private static final long serialVersionUID = 1810849469483511849L;
    private List<Turtle> turtles = new ArrayList<Turtle>();
    private Image image;
    private Turtle.Animals animal = Turtle.Animals.Turtle;

    public MultiTurtlePanel() {
        super("So Many Turtles");
        this.image = this.loadAnimal();
    }

    public void addTurtle(Turtle turtle) {
        if (turtle == null) {
            return;
        }
        this.turtles.add(turtle);
        turtle.setPanel(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = ProgramWindow.configureGraphics2D(g);
        this.paintLines(g2d);
        this.paintTurtle(g2d);
        g2d.dispose();
    }

    @Override
    public synchronized Image getImage() {
        return this.image;
    }

    @Override
    public synchronized void setAnimal(Turtle.Animals animal) {
        this.animal = animal;
        this.image = this.loadAnimal();
    }

    private Image loadAnimal() {
        return ObjectUtils.loadImage(MultiTurtlePanel.class, (Object)((Object)this.animal) + ".png");
    }

    private void paintLines(Graphics2D g2d) {
        if (this.turtles == null) {
            return;
        }
        for (Turtle turtle : this.turtles) {
            this.paintTrail(g2d, turtle.getTrail());
        }
    }

    private void paintTrail(Graphics2D g2d, LineSegment[] trail) {
        for (LineSegment l : trail) {
            g2d.setColor(l.getColor());
            g2d.setStroke(new BasicStroke(l.getWidth(), 0, 0));
            g2d.draw(new Line2D.Double(l.getStart().x, l.getStart().y, l.getEnd().x, l.getEnd().y));
        }
    }

    private void paintTurtle(Graphics2D g) {
        for (Turtle turtle : this.turtles) {
            if (turtle.isHidden()) continue;
            Image image = this.getImage();
            int xCenter = image.getWidth(null) / 2;
            int yCenter = image.getHeight(null) / 2;
            int x = turtle.getX() - xCenter;
            int y = turtle.getY() - yCenter;
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(turtle.getHeadingInDegrees()), xCenter, yCenter);
            AffineTransform move = AffineTransform.getTranslateInstance(x, y);
            move.concatenate(rotate);
            g.drawImage(image, move, null);
        }
    }

    public int getTurtleCount() {
        return this.turtles.size();
    }
}

