/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.writers;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.teachingextensions.approvals.lite.ApprovalWriter;
import org.teachingextensions.approvals.lite.writers.ImageApprovalWriter;

public class ComponentApprovalWriter
implements ApprovalWriter {
    private ImageApprovalWriter image = null;

    public ComponentApprovalWriter(Component c) {
        BufferedImage image = ComponentApprovalWriter.drawComponent(c);
        this.image = new ImageApprovalWriter(image);
    }

    public static BufferedImage drawComponent(Component c) {
        ComponentApprovalWriter.validateComponent(c);
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        c.paint(g);
        g.dispose();
        return image;
    }

    private static void validateComponent(Component c) {
        if (!c.isValid()) {
            JFrame frame = new JFrame();
            frame.getContentPane().add(c);
            frame.pack();
        }
    }

    @Override
    public String getApprovalFilename(String base) {
        return this.image.getApprovalFilename(base);
    }

    @Override
    public String getReceivedFilename(String base) {
        return this.image.getReceivedFilename(base);
    }

    @Override
    public String writeReceivedFile(String filename) throws Exception {
        return this.image.writeReceivedFile(filename);
    }
}

