/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.util.servlets;

import java.util.HashMap;
import java.util.HashSet;
import org.teachingextensions.approvals.lite.util.StringUtils;

public class ValidationError
extends RuntimeException {
    private static final long serialVersionUID = 7940285202708976073L;
    private HashMap<String, String> errors = new HashMap();
    private HashSet<String> assertions = new HashSet();

    public ValidationError(Enum<?>[] enumerations) {
        for (Enum<?> e : enumerations) {
            this.assertions.add(e.toString());
        }
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Validation(s) failed " + this.errors.keySet().toString() + " - " + this.errors.values().toString();
    }

    public void set(Enum<?> assertion, boolean isOk, String errorDescription) {
        this.setError(assertion.toString(), !isOk, errorDescription);
    }

    public void setError(String assertion, boolean isError, String errorDescription) {
        if (isError && !StringUtils.isNonZero(errorDescription)) {
            throw new Error("You can not use empty error descriptions");
        }
        this.assertValidAssertion(assertion);
        if (isError) {
            this.errors.put(assertion, errorDescription);
        } else {
            this.errors.remove(assertion);
        }
    }

    public boolean isOk() {
        return this.errors.size() == 0;
    }

    private void assertValidAssertion(String assertion) {
        if (!this.assertions.contains(assertion)) {
            throw new Error("Assertion '" + assertion + "' not found from " + this.assertions.toString());
        }
    }

    public int size() {
        return this.errors.size();
    }
}

