/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.teachingextensions.approvals.lite.util.FrameCloser;
import org.teachingextensions.approvals.lite.util.MySystem;

public class WindowUtils {
    public static void centerWindow(Window window) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = window.getSize();
        int dx = (int)w.getWidth();
        int dy = (int)w.getHeight();
        int x = (int)((d.getWidth() - (double)dx) / 2.0);
        int y = (int)((d.getHeight() - (double)dy) / 2.0);
        MySystem.variable(" size (" + x + "," + y + "," + dx + "," + dy + ")");
        window.setBounds(x, y, dx, dy + 1);
    }

    public static void testFrame(JFrame frame) {
        WindowUtils.testFrame(frame, true);
    }

    public static void copyToClipBoard(String code, boolean displayMessage) {
        StringSelection selection = new StringSelection(code);
        Frame frame = new Frame();
        frame.getToolkit().getSystemClipboard().setContents(selection, selection);
        if (displayMessage) {
            JOptionPane.showMessageDialog(null, "Code copied to Clipboard", "Finished", 1);
        }
        frame.dispose();
    }

    public static void testFrame(JFrame frame, boolean closeOnExit) {
        if (closeOnExit) {
            WindowUtils.testFrame(frame, new FrameCloser());
        } else {
            WindowUtils.testFrame(frame);
        }
    }

    public static void testFrame(JFrame frame, WindowAdapter ... array) {
        frame.pack();
        for (WindowAdapter closer : array) {
            frame.addWindowListener(closer);
        }
        WindowUtils.centerWindow(frame);
        frame.setVisible(true);
    }
}

