/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchingFileFilter
implements FilenameFilter {
    private final List<String> matches;

    public SearchingFileFilter(List<String> matches) {
        this.matches = matches;
    }

    public SearchingFileFilter(String ... matches) {
        ArrayList<String> m = new ArrayList<String>();
        m.addAll(Arrays.asList(matches));
        this.matches = m;
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean directory = new File(dir, name).isDirectory();
        return this.accept(name, directory);
    }

    public boolean accept(String name, boolean directory) {
        if (name.startsWith(".")) {
            return false;
        }
        if (this.matches.get(0).equals("*")) {
            return directory || name.equals(this.matches.get(1));
        }
        return name.equals(this.matches.get(0));
    }

    public List<String> getSubset(String file2) {
        if (this.matches.get(0).equals("*")) {
            if (this.matches.get(1).equals(file2)) {
                return this.matches.subList(2, this.matches.size());
            }
            return this.matches;
        }
        return this.matches.subList(1, this.matches.size());
    }
}

