/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.util;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;

public class MySystem {
    public static boolean event = true;
    public static boolean variable = true;
    public static int hourGlass = 0;
    private static long lastTime = System.currentTimeMillis();
    private static PrintWriter SYSTEM_OUT_WRITER = new PrintWriter(System.out, true);

    private static void clearHourGlass() {
        if (hourGlass > 0) {
            System.out.println("");
            hourGlass = 0;
        }
    }

    private static String getIndent() {
        return "";
    }

    private static String timeStamp() {
        MySystem.clearHourGlass();
        long current = System.currentTimeMillis();
        DateFormat df = DateFormat.getDateTimeInstance();
        String text = "[" + df.format(new Date(current)) + " ~" + MySystem.padNumber(current - lastTime) + "ms]" + MySystem.getIndent();
        lastTime = current;
        return text;
    }

    private static String padNumber(long number) {
        String text = "" + number;
        while (text.length() < 6) {
            text = "0" + text;
        }
        return text;
    }

    private static String indentMessage(String message) {
        Vector<Integer> v = new Vector<Integer>();
        int place = 0;
        while ((place = message.indexOf(10, place + 1)) != -1) {
            v.addElement(place);
        }
        if (v.size() == 0) {
            return message;
        }
        String theIndention = MySystem.getIndent();
        StringBuilder buffer = new StringBuilder(message);
        for (int i = v.size() - 1; i >= 0; --i) {
            int template = (Integer)v.elementAt(i);
            buffer.insert(template + 1, theIndention);
        }
        return buffer.toString();
    }

    public static synchronized void variable(String statement) {
        MySystem.variable(statement, SYSTEM_OUT_WRITER);
    }

    public static synchronized void variable(String statement, PrintWriter out) {
        if (!variable) {
            return;
        }
        out.println(MySystem.timeStamp() + "*=>" + statement);
    }

    public static synchronized void variable(String name, Object value) {
        if (!variable) {
            return;
        }
        System.out.println(MySystem.timeStamp() + "*=> " + name + " = '" + (value == null ? null : value.toString()) + "'");
    }

    public static synchronized void message(String Statement) {
        System.out.println(MySystem.timeStamp() + MySystem.indentMessage(Statement));
    }

    public static void event(String Statement) {
        if (!event) {
            return;
        }
        System.out.println(MySystem.timeStamp() + "*--" + Statement);
    }

    public static synchronized void warning(String statement) {
        MySystem.warning(statement, null);
    }

    public static synchronized void warning(Throwable throwable) {
        MySystem.warning(null, throwable);
    }

    public static synchronized void warning(String statement, Throwable throwable) {
        MySystem.warning(statement, throwable, null);
    }

    public static synchronized void warning(String statement, Throwable throwable, PrintWriter out) {
        MySystem.clearHourGlass();
        MySystem.dualPrintln("******************************************************************************************", out);
        MySystem.dualPrintln(MySystem.timeStamp(), out);
        if (statement != null) {
            MySystem.dualPrintln(statement, out);
        }
        MySystem.printFullTrace(throwable, false, out);
        if (throwable instanceof OutOfMemoryError) {
            MySystem.dumpMemory(out);
        }
        MySystem.dualPrintln("******************************************************************************************", out);
    }

    private static void dualPrintln(String string, PrintWriter out) {
        System.out.println(string);
        if (out != null) {
            out.println(string);
        }
    }

    private static void printFullTrace(Throwable throwable, boolean causedBy, PrintWriter out) {
        if (throwable != null) {
            MySystem.dualPrintln((causedBy ? "Caused by : " : "") + throwable.getMessage(), out);
            throwable.printStackTrace();
            if (out != null) {
                throwable.printStackTrace(out);
            }
            if (throwable.getCause() != null) {
                MySystem.printFullTrace(throwable.getCause(), true, out);
            }
        }
    }

    public static void dumpMemory(PrintWriter out) {
        System.gc();
        NumberFormat format = NumberFormat.getNumberInstance();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long usedMemory = totalMemory - freeMemory;
        String statement = "Memory [total, used, free] = [" + format.format(totalMemory) + " , " + format.format(usedMemory) + " , " + format.format(freeMemory) + "]";
        MySystem.variable(statement, out);
    }
}

