/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teachingextensions.approvals.lite.util.FormattedException;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.approvals.lite.util.SearchingFileFilter;

public class ClassUtils {
    public static Class<?> getWrapperClass(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return primitiveType;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes) != null;
        }
        catch (SecurityException e) {
            throw ObjectUtils.throwAsError(e);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static File getSourceDirectory(Class<?> clazz) {
        String name = clazz.getName();
        String[] split = name.split("\\.");
        split[split.length - 1] = split[split.length - 1] + ".java";
        File found = ClassUtils.find(new File("."), Arrays.asList(split));
        if (found == null) {
            throw new FormattedException("Didn't find %s under %s", name, new File("."));
        }
        return found.getParentFile();
    }

    public static File find(File file, List<String> matches) {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(matches);
        copy.add(0, "*");
        return ClassUtils.find2(file, copy);
    }

    public static File find2(File file, List<String> matches) {
        File[] listFiles;
        SearchingFileFilter searchingFileFilter = new SearchingFileFilter(matches);
        for (File file2 : listFiles = file.listFiles(searchingFileFilter)) {
            if (file2.isDirectory()) {
                File found = ClassUtils.find2(file2, searchingFileFilter.getSubset(file2.getName()));
                if (found == null) continue;
                return found;
            }
            return file2;
        }
        return null;
    }

    public static <T> T create(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw ObjectUtils.throwAsError(e);
        }
    }
}

