/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.reporters;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.teachingextensions.approvals.lite.reporters.EnvironmentAwareReporter;
import org.teachingextensions.approvals.lite.util.ThreadUtils;
import org.teachingextensions.approvals.lite.util.io.FileUtils;

public class GenericDiffReporter
implements EnvironmentAwareReporter {
    public static final String STANDARD_ARGUMENTS = "%s %s";
    public static boolean REPORT_MISSING_FILES = false;
    protected String diffProgram;
    protected String arguments;
    protected String diffProgramNotFoundMessage;
    private List<String> validExtensions;
    public static List<String> TEXT_FILE_EXTENSIONS = Arrays.asList(".txt", ".csv", ".htm", ".html", ".xml", ".eml", ".java", ".css", ".js");
    public static List<String> IMAGE_FILE_EXTENSIONS = Arrays.asList(".png", ".gif", ".jpg", ".jpeg", ".bmp", ".tif", ".tiff");

    public GenericDiffReporter(String diffProgram, String diffProgramNotFoundMessage) {
        this(diffProgram, STANDARD_ARGUMENTS, diffProgramNotFoundMessage);
    }

    private GenericDiffReporter(String diffProgram, String argumentsFormat, String diffProgramNotFoundMessage) {
        this(diffProgram, argumentsFormat, diffProgramNotFoundMessage, TEXT_FILE_EXTENSIONS);
    }

    public GenericDiffReporter(String diffProgram, String argumentsFormat, String diffProgramNotFoundMessage, List<String> validFileExtensions) {
        this.diffProgram = diffProgram;
        this.arguments = argumentsFormat;
        this.diffProgramNotFoundMessage = diffProgramNotFoundMessage;
        this.validExtensions = validFileExtensions;
    }

    @Override
    public void report(String received, String approved) throws Exception {
        if (!this.isWorkingInThisEnvironment(received)) {
            throw new RuntimeException(this.diffProgramNotFoundMessage);
        }
        FileUtils.createIfNeeded(approved);
        this.launch(received, approved);
    }

    private void launch(String received, String approved) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.getCommandLine(received, approved));
        builder.start();
        ThreadUtils.sleep(500L);
    }

    public String[] getCommandLine(String received, String approved) {
        String[] p = this.arguments.split(" ");
        String r = String.format(p[0], received);
        String a = String.format(p[1], approved);
        Object[] commands = new String[]{this.diffProgram, r, a};
        System.out.println(Arrays.toString(commands));
        return commands;
    }

    @Override
    public boolean isWorkingInThisEnvironment(String forFile) {
        return this.checkFileExists() && this.isFileExtensionHandled(forFile);
    }

    public boolean checkFileExists() {
        boolean exists = new File(this.diffProgram).exists();
        if (REPORT_MISSING_FILES && !exists) {
            System.out.println(String.format("%s can't find '%s'", this.getClass().getSimpleName(), this.diffProgram));
        }
        return exists;
    }

    public boolean isFileExtensionHandled(String forFile) {
        return GenericDiffReporter.isFileExtensionValid(forFile, this.validExtensions);
    }

    public static boolean isFileExtensionValid(String forFile, List<String> validExtensionsWithDot) {
        String extensionWithDot = FileUtils.getExtensionWithDot(forFile);
        return validExtensionsWithDot.contains(extensionWithDot);
    }
}

