/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite.reporters;

import java.awt.GraphicsEnvironment;
import java.io.File;
import org.teachingextensions.approvals.lite.reporters.EnvironmentAwareReporter;
import org.teachingextensions.approvals.lite.util.SystemUtils;
import org.teachingextensions.approvals.lite.util.WindowUtils;

public class ClipboardReporter
implements EnvironmentAwareReporter {
    @Override
    public void report(String received, String approved) throws Exception {
        WindowUtils.copyToClipBoard(ClipboardReporter.getCommandLine(received, approved), false);
    }

    public static String getCommandLine(String received, String approved) {
        File r = new File(received);
        File a = new File(approved);
        return ClipboardReporter.getAcceptApprovalText(r.getAbsolutePath(), a.getAbsolutePath());
    }

    @Override
    public boolean isWorkingInThisEnvironment(String forFile) {
        return !GraphicsEnvironment.isHeadless();
    }

    public static String getAcceptApprovalText(String received, String approved) {
        if (SystemUtils.isWindowsEnvironment()) {
            return String.format("move /Y \"%s\"  \"%s\"", received, approved);
        }
        return String.format("mv %s %s", received, approved);
    }
}

