/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.teachingextensions.approvals.lite.ApprovalFailureReporter;
import org.teachingextensions.approvals.lite.reporters.DiffReporter;
import org.teachingextensions.approvals.lite.reporters.FileLauncherReporter;
import org.teachingextensions.approvals.lite.reporters.ImageReporter;
import org.teachingextensions.approvals.lite.reporters.MultiReporter;
import org.teachingextensions.approvals.lite.reporters.QuietReporter;
import org.teachingextensions.approvals.lite.reporters.UseReporter;
import org.teachingextensions.approvals.lite.util.ClassUtils;

public class ReporterFactory {
    private static HashMap<String, Class<? extends ApprovalFailureReporter>> reporters = new HashMap();

    public static ApprovalFailureReporter get(String string) {
        ApprovalFailureReporter returned = ReporterFactory.getFromAnnotation();
        returned = ReporterFactory.tryFor(returned, reporters.get(string));
        returned = ReporterFactory.tryFor(returned, reporters.get("default"));
        return returned;
    }

    public static ApprovalFailureReporter getFromAnnotation() {
        UseReporter reporter = ReporterFactory.getAnnotationFromStackTrace(UseReporter.class);
        return reporter == null ? null : ReporterFactory.getReporter(reporter);
    }

    private static ApprovalFailureReporter getReporter(UseReporter reporter) {
        Class<? extends ApprovalFailureReporter>[] classes = reporter.value();
        ArrayList<ApprovalFailureReporter> reporters = new ArrayList<ApprovalFailureReporter>();
        for (Class<? extends ApprovalFailureReporter> clazz : classes) {
            ApprovalFailureReporter instance = ClassUtils.create(clazz);
            reporters.add(instance);
        }
        return reporters.size() == 1 ? (ApprovalFailureReporter)reporters.get(0) : new MultiReporter(reporters);
    }

    private static <T extends Annotation> T getAnnotationFromStackTrace(Class<T> annotationClass) {
        StackTraceElement[] trace;
        for (StackTraceElement stack : trace = Thread.currentThread().getStackTrace()) {
            Method method = null;
            Class<?> clazz = null;
            try {
                String methodName = stack.getMethodName();
                clazz = Class.forName(stack.getClassName());
                method = clazz.getMethod(methodName, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            T annotation = null;
            if (method != null) {
                annotation = method.getAnnotation(annotationClass);
            }
            if (annotation != null) {
                return annotation;
            }
            T t = annotation = clazz != null ? (T)clazz.getAnnotation(annotationClass) : null;
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static ApprovalFailureReporter tryFor(ApprovalFailureReporter returned, Class<? extends ApprovalFailureReporter> trying) {
        if (returned == null && trying != null) {
            return ClassUtils.create(trying);
        }
        return returned;
    }

    private static void setupReporters() {
        reporters.put("txt", DiffReporter.class);
        reporters.put("html", DiffReporter.class);
        reporters.put("csv", FileLauncherReporter.class);
        reporters.put("file", FileLauncherReporter.class);
        reporters.put("png", ImageReporter.class);
        reporters.put("default", QuietReporter.class);
    }

    static {
        ReporterFactory.setupReporters();
    }

    public static class FileTypes {
        public static final String Text = "txt";
        public static final String Html = "html";
        public static final String Excel = "csv";
        public static final String File = "file";
        public static final String Image = "png";
        private static final String Default = "default";
    }
}

