/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.teachingextensions.approvals.lite.ApprovalApprover;
import org.teachingextensions.approvals.lite.ApprovalFailureOverrider;
import org.teachingextensions.approvals.lite.ApprovalFailureReporter;
import org.teachingextensions.approvals.lite.ApprovalReporterWithCleanUp;
import org.teachingextensions.approvals.lite.ApprovalWriter;
import org.teachingextensions.approvals.lite.namer.ApprovalNamer;
import org.teachingextensions.approvals.lite.namer.NamerFactory;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.approvals.lite.util.io.FileUtils;

public class FileApprover
implements ApprovalApprover {
    private File received;
    private File approved;
    private final ApprovalWriter writter;

    public FileApprover(ApprovalWriter writter, ApprovalNamer namer) {
        this.writter = writter;
        String base = String.format("%s%s%s", namer.getSourceFilePath(), namer.getApprovalName(), NamerFactory.getAndClearAdditionalInformation());
        this.received = new File(writter.getReceivedFilename(base));
        this.approved = new File(writter.getApprovalFilename(base));
    }

    @Override
    public boolean approve() throws Exception {
        this.received = new File(this.writter.writeReceivedFile(this.received.getAbsolutePath()));
        return FileApprover.approveTextFile(this.received, this.approved);
    }

    @Override
    public void cleanUpAfterSuccess(ApprovalFailureReporter reporter) throws Exception {
        this.received.delete();
        if (reporter instanceof ApprovalReporterWithCleanUp) {
            ((ApprovalReporterWithCleanUp)((Object)reporter)).cleanUp(this.received.getAbsolutePath(), this.approved.getAbsolutePath());
        }
    }

    @Override
    public void reportFailure(ApprovalFailureReporter reporter) throws Exception {
        reporter.report(this.received.getAbsolutePath(), this.approved.getAbsolutePath());
    }

    @Override
    public void fail() {
        TestCase.assertEquals((String)"Failed Approval", (String)this.approved.getAbsolutePath(), (String)this.received.getAbsolutePath());
    }

    public static boolean approveTextFile(File expected, File actual) throws IOException {
        if (!expected.exists() || !actual.exists()) {
            return false;
        }
        String t1 = FileUtils.readFile(expected);
        String t2 = FileUtils.readFile(actual);
        return ObjectUtils.isEqual(t1, t2);
    }

    public boolean askToChangeReceivedToApproved(ApprovalFailureOverrider reporter) throws Exception {
        return reporter.askToChangeReceivedToApproved(this.received.getAbsolutePath(), this.approved.getAbsolutePath());
    }
}

