/*
 * Decompiled with CFR 0.152.
 */
package org.teachingextensions.approvals.lite;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.teachingextensions.approvals.lite.ApprovalFailureOverrider;
import org.teachingextensions.approvals.lite.ApprovalFailureReporter;
import org.teachingextensions.approvals.lite.ApprovalWriter;
import org.teachingextensions.approvals.lite.FileApprover;
import org.teachingextensions.approvals.lite.ReporterFactory;
import org.teachingextensions.approvals.lite.namer.ApprovalNamer;
import org.teachingextensions.approvals.lite.namer.JUnitStackTraceNamer;
import org.teachingextensions.approvals.lite.util.ArrayUtils;
import org.teachingextensions.approvals.lite.util.ObjectUtils;
import org.teachingextensions.approvals.lite.util.StringUtils;
import org.teachingextensions.approvals.lite.util.lambda.Function1;
import org.teachingextensions.approvals.lite.writers.ApprovalTextWriter;
import org.teachingextensions.approvals.lite.writers.ComponentApprovalWriter;
import org.teachingextensions.approvals.lite.writers.ImageApprovalWriter;

public class Approvals {
    public static void verify(String response) throws Exception {
        Approvals.verify(new ApprovalTextWriter(response, "txt"), "txt");
    }

    public static <T> void verifyAll(String header, T[] values) {
        Approvals.verifyAll(header, Arrays.asList(values));
    }

    public static <T> void verifyAll(String header, Iterable<T> values) {
        Approvals.verifyAll(header, values, new Function1<T, String>(){

            @Override
            public String call(T i) {
                return i + "";
            }
        });
    }

    public static <T> void verifyAll(String header, T[] values, Function1<T, String> f1) {
        Approvals.verifyAll(header, Arrays.asList(values), f1);
    }

    public static <T> void verifyAll(String header, Iterable<T> array, Function1<T, String> f1) {
        String text = Approvals.formatHeader(header) + ArrayUtils.toString(array, f1);
        Approvals.verify(new ApprovalTextWriter(text, "txt"), "txt");
    }

    private static String formatHeader(String header) {
        return StringUtils.isEmpty(header) ? "" : header + "\r\n\r\n\r\n";
    }

    public static void verifyHtml(String response) throws Exception {
        Approvals.verify(new ApprovalTextWriter(response, "html"), "html");
    }

    public static void verify(Component component) {
        Approvals.verify(new ComponentApprovalWriter(component), "png");
    }

    public static void verify(BufferedImage bufferedImage) {
        Approvals.verify(new ImageApprovalWriter(bufferedImage), "png");
    }

    public static void verify(ApprovalWriter writer, ApprovalNamer namer, ApprovalFailureReporter reporter) {
        Approvals.verify(new FileApprover(writer, namer), reporter);
    }

    public static void verify(ApprovalWriter writer, String fileType) {
        Approvals.verify(writer, Approvals.createApprovalNamer(), ReporterFactory.get(fileType));
    }

    public static void verify(FileApprover approver, ApprovalFailureReporter reporter) {
        try {
            if (!approver.approve()) {
                boolean passed = false;
                if (reporter instanceof ApprovalFailureOverrider) {
                    passed = approver.askToChangeReceivedToApproved((ApprovalFailureOverrider)reporter);
                }
                if (!passed) {
                    approver.reportFailure(reporter);
                    approver.fail();
                } else {
                    approver.cleanUpAfterSuccess(reporter);
                }
            } else {
                approver.cleanUpAfterSuccess(reporter);
            }
        }
        catch (Exception e) {
            throw ObjectUtils.throwAsError(e);
        }
    }

    public static ApprovalNamer createApprovalNamer() {
        return new JUnitStackTraceNamer();
    }

    public static void verify(Object o) throws Exception {
        Approvals.verify(o + "");
    }
}

