package org.apereo.cas;

import module java.base;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.spring.boot.SpringBootTestAutoConfigurations;
import lombok.val;
import org.apache.commons.io.output.WriterOutputStream;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.env.Environment;
import static org.junit.jupiter.api.Assertions.*;

/**
 * This is {@link CasTomcatBannerTests}.
 *
 * @author Misagh Moayyed
 * @since 5.3.0
 */
@SpringBootTestAutoConfigurations
@SpringBootTest(classes = AopAutoConfiguration.class)
@Tag("ApacheTomcat")
@ExtendWith(CasTestExtension.class)
class CasTomcatBannerTests {
    @Autowired
    private Environment environment;

    @Test
    void verifyAction() throws Throwable {
        val banner = new CasTomcatBanner();
        val writer = new StringWriter();
        val out = WriterOutputStream.builder().setWriter(writer).get();
        try (val stream = new PrintStream(out, true, StandardCharsets.UTF_8)) {
            banner.printBanner(environment, CasTomcatBanner.class, stream);
        }
        val output = writer.toString();
        assertNotNull(output);
    }
}
