package org.apereo.cas.adaptors.yubikey.dao;

import module java.base;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Tag;
import org.springframework.test.context.TestPropertySource;

/**
 * This is {@link MicrosoftSQLServerJpaYubiKeyAccountRegistryTests}.
 *
 * @author Misagh Moayyed
 * @since 6.2.0
 */
@EnabledIfListeningOnPort(port = 1433)
@Tag("MsSqlServer")
@TestPropertySource(properties = {
    "cas.jdbc.show-sql=false",
    "cas.authn.mfa.yubikey.jpa.user=sa",
    "cas.authn.mfa.yubikey.jpa.password=p@ssw0rd",
    "cas.authn.mfa.yubikey.jpa.driver-class=com.microsoft.sqlserver.jdbc.SQLServerDriver",
    "cas.authn.mfa.yubikey.jpa.url=jdbc:sqlserver://localhost:1433;databaseName=yubikey;useUnicode=true;characterEncoding=UTF-8;encrypt=false;trustServerCertificate=true",
    "cas.authn.mfa.yubikey.jpa.dialect=org.hibernate.dialect.SQLServerDialect"
})
class MicrosoftSQLServerJpaYubiKeyAccountRegistryTests extends JpaYubiKeyAccountRegistryTests {
}
