package org.apereo.cas.adaptors.yubikey;

import module java.base;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

/**
 * This is {@link JpaYubiKeyAccount}.
 *
 * @author Misagh Moayyed
 * @since 6.2.0
 */
@Getter
@Entity
@Setter
@Table(name = "YubiKeyAccount")
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
public class JpaYubiKeyAccount extends YubiKeyAccount {
    @Serial
    private static final long serialVersionUID = 8996204730235225057L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    @Override
    public YubiKeyAccount setId(final long id) {
        super.setId(id);
        this.id = id;
        return this;
    }
}
