package org.apereo.cas.web.view.attributes;

import module java.base;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import lombok.val;

/**
 * This is {@link AttributeValuesPerLineProtocolAttributesRenderer}.
 *
 * @author Misagh Moayyed
 * @since 6.0.0
 */
public class AttributeValuesPerLineProtocolAttributesRenderer implements CasProtocolAttributesRenderer {
    @Override
    public Collection<String> render(final Map<String, Object> attributes) {
        val formattedAttributes = new ArrayList<String>(attributes.size());
        attributes.forEach((key, value) -> {
            val attributeValues = CollectionUtils.toCollection(value)
                .stream()
                .map(Object::toString)
                .collect(Collectors.joining(","));
            val name = CasProtocolAttributesRenderer.sanitizeAttributeName(key);
            formattedAttributes.add(name.concat("=").concat(attributeValues));
        });
        return formattedAttributes;
    }
}
