package org.apereo.cas.trusted.authentication.storage;

import module java.base;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Tag;
import org.springframework.test.context.TestPropertySource;

/**
 * Test cases for {@link JpaMultifactorAuthenticationTrustStorage}.
 *
 * @author Daniel Frett
 * @since 5.3.0
 */
@TestPropertySource(properties = {
    "cas.jdbc.show-sql=false",
    "cas.authn.mfa.trusted.jpa.ddl-auto=create-drop",

    "cas.authn.mfa.trusted.jpa.user=system",
    "cas.authn.mfa.trusted.jpa.password=Oradoc_db1",
    "cas.authn.mfa.trusted.jpa.driver-class=oracle.jdbc.driver.OracleDriver",
    "cas.authn.mfa.trusted.jpa.url=jdbc:oracle:thin:@localhost:1521:FREE",
    "cas.authn.mfa.trusted.jpa.dialect=org.hibernate.dialect.OracleDialect"
})
@EnabledIfListeningOnPort(port = 1521)
@Tag("Oracle")
class OracleJpaMultifactorAuthenticationTrustStorageTests extends JpaMultifactorAuthenticationTrustStorageTests {
}
