package org.apereo.cas.token.authentication;

import module java.base;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Service;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * This is {@link TokenCredential} that represents the user credentials in form of an encrypted token.
 *
 * @author Misagh Moayyed
 * @since 4.2.0
 */
@ToString(callSuper = true)
@Getter
@Setter
public class TokenCredential extends BasicIdentifiableCredential {

    @Serial
    private static final long serialVersionUID = 2749515041385101770L;

    private Service service;

    public TokenCredential(final String tokenId, final Service service) {
        super(tokenId);
        this.service = service;
    }
}
