package org.apereo.cas.support.sms;

import module java.base;
import org.apereo.cas.configuration.model.support.sms.TextMagicProperties;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

/**
 * This is {@link TextMagicSmsSenderTests}.
 *
 * @author Misagh Moayyed
 * @since 5.3.0
 */
@Tag("SMS")
class TextMagicSmsSenderTests {
    @Test
    void verifyAction() {
        val props = new TextMagicProperties();
        props.setUsername("casuser");
        props.setPassword("password");
        props.setUserAgent("agent");
        val sender = new TextMagicSmsSender(props, Optional.empty());
        assertFalse(sender.send("123456678", "123456678", "Msg"));
    }
}
