package org.apereo.cas.mfa.simple.ticket;

import module java.base;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * This is {@link CasSimpleMultifactorAuthenticationTicketImpl}.
 *
 * @author Misagh Moayyed
 * @since 6.3.0
 */
@ToString(callSuper = true)
@Getter
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonIdentityInfo(generator = ObjectIdGenerators.IntSequenceGenerator.class)
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS)
public class CasSimpleMultifactorAuthenticationTicketImpl extends AbstractTicket
    implements CasSimpleMultifactorAuthenticationTicket {
    @Serial
    private static final long serialVersionUID = -6580305495605099699L;

    /**
     * The Service.
     */
    private Service service;

    public CasSimpleMultifactorAuthenticationTicketImpl(final String id, final ExpirationPolicy expirationPolicy,
                                                        final Service service,
                                                        @JsonSetter(nulls = Nulls.AS_EMPTY)
                                                        final Map<String, Serializable> properties) {
        super(id, expirationPolicy);
        this.service = service;
        setProperties(new HashMap<>(properties));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}
