package org.apereo.cas.support.saml;

import module java.base;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.jspecify.annotations.NonNull;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

/**
 * This is {@link EntityDescriptorMetadataResolver}.
 *
 * @author Misagh Moayyed
 * @since 7.3.0
 */
public class EntityDescriptorMetadataResolver extends AbstractMetadataResolver {
    private final EntityDescriptor entityDescriptor;

    public EntityDescriptorMetadataResolver(final EntityDescriptor entityDescriptor, final OpenSamlConfigBean openSamlConfigBean) {
        this.entityDescriptor = entityDescriptor;
        setId(Objects.requireNonNull(entityDescriptor.getEntityID()));
        setRequireValidMetadata(true);
        setParserPool(openSamlConfigBean.getParserPool());
        setFailFastInitialization(true);
    }

    @NonNull
    @Override
    protected Iterable<EntityDescriptor> doResolve(final CriteriaSet criteria) {
        return List.of(entityDescriptor);
    }
}
           
