package org.apereo.cas.web.flow.actions.logout;

import module java.base;
import org.apereo.cas.support.saml.idp.slo.SamlIdPProfileSingleLogoutRequestProcessor;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import lombok.RequiredArgsConstructor;
import org.jspecify.annotations.Nullable;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/**
 * This is {@link DelegatedSaml2ClientIdPRestoreSloRequestAction}.
 *
 * @author Misagh Moayyed
 * @since 7.3.0
 */
@RequiredArgsConstructor
public class DelegatedSaml2ClientIdPRestoreSloRequestAction extends BaseCasWebflowAction {
    private final SamlIdPProfileSingleLogoutRequestProcessor delegatedSaml2IdPSloRequestProcessor;

    @Override
    protected @Nullable Event doExecuteInternal(final RequestContext requestContext) throws Throwable {
        delegatedSaml2IdPSloRequestProcessor.restore(requestContext);
        return null;
    }
}
