package org.apereo.cas.validation;

import module java.base;
import org.apereo.cas.audit.AuditActionResolvers;
import org.apereo.cas.audit.AuditResourceResolvers;
import org.apereo.cas.audit.AuditableActions;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.services.UnauthorizedServiceException;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.core.client.Client;

/**
 * This is {@link RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer}.
 *
 * @author Misagh Moayyed
 * @since 5.3.0
 */
@Slf4j
public class RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer extends BaseAuditableExecution {
    @Audit(action = AuditableActions.DELEGATED_CLIENT,
        actionResolverName = AuditActionResolvers.DELEGATED_CLIENT_ACTION_RESOLVER,
        resourceResolverName = AuditResourceResolvers.DELEGATED_CLIENT_RESOURCE_RESOLVER)
    @Override
    public AuditableExecutionResult execute(final AuditableContext context) {
        val result = AuditableExecutionResult.of(context);
        if (context.getRegisteredService().isPresent() && context.getProperties().containsKey(Client.class.getSimpleName())) {
            val registeredService = context.getRegisteredService().orElseThrow();
            val clientName = context.getProperties().get(Client.class.getSimpleName()).toString();
            LOGGER.trace("Checking delegated access strategy of [{}] for client [{}]", registeredService, clientName);
            val policy = registeredService.getAccessStrategy().getDelegatedAuthenticationPolicy();
            if (policy != null && !policy.isProviderAllowed(clientName, registeredService)) {
                LOGGER.debug("Delegated access strategy for [{}] does not permit client [{}]", registeredService, clientName);
                result.setException(UnauthorizedServiceException.denied(clientName));
            }
        }
        return result;
    }
}
