package org.apereo.cas.oidc.web.flow;

import module java.base;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.webflow.execution.RequestContext;

/**
 * This is {@link OidcCasWebflowLoginContextProvider}.
 *
 * @author Misagh Moayyed
 * @since 6.4.0
 */
@RequiredArgsConstructor
public class OidcCasWebflowLoginContextProvider implements CasWebflowLoginContextProvider {
    private final ArgumentExtractor argumentExtractor;

    @Override
    public Optional<String> getCandidateUsername(final RequestContext context) {
        val request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        val service = argumentExtractor.extractService(request);
        val hint = Optional.ofNullable(service)
            .map(svc -> (List) svc.getAttributes().getOrDefault(OidcConstants.LOGIN_HINT, List.of()))
            .orElseGet(List::of);
        return hint.isEmpty() ? Optional.empty() : Optional.ofNullable(hint.getFirst().toString());
    }
}
