package org.apereo.cas.uma.discovery;

import module java.base;
import org.apereo.cas.configuration.CasConfigurationProperties;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.FactoryBean;

/**
 * This is {@link UmaServerDiscoverySettingsFactory}.
 *
 * @author Misagh Moayyed
 * @since 6.0.0
 */
@RequiredArgsConstructor
public class UmaServerDiscoverySettingsFactory implements FactoryBean<@NonNull UmaServerDiscoverySettings> {
    private final CasConfigurationProperties casProperties;

    @Override
    public UmaServerDiscoverySettings getObject() {
        val uma = casProperties.getAuthn().getOauth().getUma();
        return new UmaServerDiscoverySettings(casProperties, uma.getCore().getIssuer());
    }

    @Override
    public Class<?> getObjectType() {
        return UmaServerDiscoverySettings.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
