package org.apereo.cas.memcached;

import module java.base;
import org.apereo.cas.configuration.model.support.memcached.BaseMemcachedProperties;
import org.apereo.cas.memcached.kryo.CasKryoPool;
import org.apereo.cas.memcached.kryo.CasKryoTranscoder;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.transcoders.WhalinTranscoder;
import net.spy.memcached.transcoders.WhalinV1Transcoder;

/**
 * This is {@link MemcachedUtils}.
 *
 * @author Misagh Moayyed
 * @since 5.2.0
 * @deprecated Since 7.0.0
 */
@Slf4j
@UtilityClass
@Deprecated(since = "7.0.0")
public class MemcachedUtils {

    /**
     * New transcoder.
     *
     * @param memcachedProperties the memcached properties
     * @return the transcoder
     */
    public static Transcoder newTranscoder(final BaseMemcachedProperties memcachedProperties) {
        return newTranscoder(memcachedProperties, new ArrayList<>());
    }

    /**
     * New transcoder.
     *
     * @param memcachedProperties     the memcached properties
     * @param kryoSerializableClasses the kryo serializable classes
     * @return the transcoder
     */
    public static Transcoder newTranscoder(final BaseMemcachedProperties memcachedProperties,
                                           final Collection<Class> kryoSerializableClasses) {
        switch (memcachedProperties.getTranscoder()) {
            case SERIAL -> {
                val serial = new SerializingTranscoder();
                serial.setCompressionThreshold(memcachedProperties.getTranscoderCompressionThreshold());
                LOGGER.debug("Creating memcached transcoder [{}]", serial.getClass().getName());
                return serial;
            }
            case WHALIN -> {
                val whalin = new WhalinTranscoder();
                whalin.setCompressionThreshold(memcachedProperties.getTranscoderCompressionThreshold());
                LOGGER.debug("Creating memcached transcoder [{}]", whalin.getClass().getName());
                return whalin;
            }
            case WHALINV1 -> {
                val whalinv1 = new WhalinV1Transcoder();
                whalinv1.setCompressionThreshold(memcachedProperties.getTranscoderCompressionThreshold());
                LOGGER.debug("Creating memcached transcoder [{}]", whalinv1.getClass().getName());
                return whalinv1;
            }
            default -> {
                val kryoPool = new CasKryoPool(kryoSerializableClasses, true,
                    memcachedProperties.isKryoRegistrationRequired(),
                    memcachedProperties.isKryoObjectsByReference(),
                    memcachedProperties.isKryoAutoReset());
                val kryo = new CasKryoTranscoder(kryoPool);
                LOGGER.debug("Creating memcached transcoder [{}]", kryo.getClass().getName());
                return kryo;
            }
        }
    }
}
