package org.apereo.cas.authentication.support;

import module java.base;
import org.apereo.cas.authentication.support.password.RejectResultCodePasswordPolicyHandlingStrategy;
import org.apereo.cas.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import org.ldaptive.auth.AuthenticationResponse;

/**
 * This is {@link RejectResultCodeLdapPasswordPolicyHandlingStrategy}.
 * Handles password policy only if the authentication response result code is not blocked.
 *
 * @author Misagh Moayyed
 * @since 5.2.0
 */
@RequiredArgsConstructor
public class RejectResultCodeLdapPasswordPolicyHandlingStrategy extends RejectResultCodePasswordPolicyHandlingStrategy<AuthenticationResponse> {
    @Override
    protected boolean isAuthenticationResponseWithResult(final AuthenticationResponse response) {
        return response.isSuccess();
    }

    @Override
    protected Collection<String> getAuthenticationResponseResultCodes(final AuthenticationResponse response) {
        return CollectionUtils.wrap(response.getAuthenticationResultCode().name());
    }
}
