package org.apereo.cas.interrupt;

import module java.base;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import lombok.Getter;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

/**
 * This is {@link DefaultInterruptInquiryExecutionPlan}.
 *
 * @author Misagh Moayyed
 * @since 6.0.0
 */
@Getter
public class DefaultInterruptInquiryExecutionPlan implements InterruptInquiryExecutionPlan {
    private final List<InterruptInquirer> interruptInquirers = new ArrayList<>();

    @Override
    public void registerInterruptInquirer(final InterruptInquirer inquirer) {
        if (BeanSupplier.isNotProxy(inquirer)) {
            interruptInquirers.add(inquirer);
        }
    }

    @Override
    public List<InterruptInquirer> getInterruptInquirers() {
        AnnotationAwareOrderComparator.sort(interruptInquirers);
        return interruptInquirers;
    }
}
