package org.apereo.cas.gua.impl;

import module java.base;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import static org.junit.jupiter.api.Assertions.*;

/**
 * This is {@link StaticUserGraphicalAuthenticationRepositoryTests}.
 *
 * @author Misagh Moayyed
 * @since 6.2.0
 */
@Tag("Simple")
class StaticUserGraphicalAuthenticationRepositoryTests {

    @Test
    void verifyImage() throws Throwable {
        val repo = new StaticUserGraphicalAuthenticationRepository(Map.of("casuser", new ClassPathResource("image.jpg")));
        assertFalse(repo.getGraphics("casuser").isEmpty());
    }

    @Test
    void verifyBadImage() throws Throwable {
        val repo = new StaticUserGraphicalAuthenticationRepository(Map.of("casuser", new ClassPathResource("missing.jpg")));
        assertTrue(repo.getGraphics("casuser").isEmpty());
    }
}
