package org.apereo.cas.support.events.dao;

import module java.base;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.jspecify.annotations.NonNull;

/**
 * This is {@link InMemoryCasEventRepository}.
 *
 * @author Misagh Moayyed
 * @since 5.1.0
 */
public class InMemoryCasEventRepository extends AbstractCasEventRepository {
    private final LoadingCache<@NonNull String, CasEvent> cache;

    public InMemoryCasEventRepository(final CasEventRepositoryFilter eventRepositoryFilter,
                                      final LoadingCache<@NonNull String, CasEvent> cache) {
        super(eventRepositoryFilter);
        this.cache = cache;
    }

    @Override
    public Stream<? extends CasEvent> load() {
        return cache.asMap().values().stream();
    }

    @Override
    public Stream<? extends CasEvent> getEventsForPrincipal(final String id) {
        return cache
            .asMap()
            .values()
            .stream()
            .filter(e -> e.getPrincipalId().equalsIgnoreCase(id));
    }

    @Override
    public CasEvent saveInternal(final CasEvent event) {
        event.assignIdIfNecessary();
        cache.put(UUID.randomUUID().toString(), event);
        return event;
    }

    @Override
    public void removeAll() {
        cache.invalidateAll();
        cache.cleanUp();
    }
}
