package org.apereo.cas.nativex;

import module java.base;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityPasscodeCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import com.duosecurity.Client;
import com.duosecurity.client.Http;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;

/**
 * This is {@link DuoSecurityRuntimeHints}.
 *
 * @author Misagh Moayyed
 * @since 7.0.0
 */
public class DuoSecurityRuntimeHints implements CasRuntimeHintsRegistrar {
    @Override
    public void registerHints(final @NonNull RuntimeHints hints, final @Nullable ClassLoader classLoader) {
        registerReflectionHints(hints,
            DuoSecurityUniversalPromptCredential.class,
            DuoSecurityPasscodeCredential.class,
            DuoSecurityDirectCredential.class);

        registerReflectionHints(hints, Http.class, Client.Builder.class);
        
        registerSerializationHints(hints,
            DuoSecurityUniversalPromptCredential.class,
            DuoSecurityPasscodeCredential.class,
            DuoSecurityDirectCredential.class);
    }
}
